/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiMember;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.codeStyle.ImportHelper;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.HashSet;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxClassBackedElementDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyElementDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxStaticPropertyAttributeDescriptor;

public class JavaFxImportsOptimizer
implements ImportOptimizer {
    public boolean supports(PsiFile file) {
        return JavaFxFileTypeFactory.isFxml(file);
    }

    @NotNull
    public Runnable processFile(final PsiFile file) {
        VirtualFile vFile = file.getVirtualFile();
        if (vFile instanceof VirtualFileWindow) {
            vFile = ((VirtualFileWindow)vFile).getDelegate();
        }
        Project project = file.getProject();
        if (vFile == null || !ProjectRootManager.getInstance((Project)project).getFileIndex().isInSourceContent(vFile)) {
            Runnable runnable = EmptyRunnable.INSTANCE;
            if (runnable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxImportsOptimizer", "processFile"));
            }
            return runnable;
        }
        ArrayList<Pair<String, Boolean>> names = new ArrayList<Pair<String, Boolean>>();
        JavaFxImportsOptimizer.collectNamesToImport(names, (XmlFile)file);
        Collections.sort(names, new Comparator<Pair<String, Boolean>>(){

            @Override
            public int compare(Pair<String, Boolean> o1, Pair<String, Boolean> o2) {
                return StringUtil.compare((String)((String)o1.first), (String)((String)o2.first), (boolean)true);
            }
        });
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project);
        List sortedNames = ImportHelper.sortItemsAccordingToSettings(names, (CodeStyleSettings)settings);
        HashSet onDemand = new HashSet();
        ImportHelper.collectOnDemandImports((List)sortedNames, (Set)onDemand, (CodeStyleSettings)settings);
        HashSet imported = new HashSet();
        ArrayList<String> imports = new ArrayList<String>();
        for (Pair pair : sortedNames) {
            String qName = (String)pair.first;
            String packageName = StringUtil.getPackageName((String)qName);
            if (imported.contains(packageName) || imported.contains(qName)) continue;
            if (onDemand.contains((Object)packageName)) {
                imported.add(packageName);
                imports.add("<?import " + packageName + ".*?>");
                continue;
            }
            imported.add(qName);
            imports.add("<?import " + qName + "?>");
        }
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)file.getProject());
        XmlFile dummyFile = (XmlFile)factory.createFileFromText("_Dummy_.fxml", (FileType)StdFileTypes.XML, (CharSequence)StringUtil.join(imports, (String)"\n"));
        final XmlDocument document = dummyFile.getDocument();
        final XmlProlog newImportList = document.getProlog();
        if (newImportList == null) {
            Runnable runnable = EmptyRunnable.getInstance();
            if (runnable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxImportsOptimizer", "processFile"));
            }
            return runnable;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                XmlDocument xmlDocument = ((XmlFile)file).getDocument();
                XmlProlog prolog = xmlDocument.getProlog();
                if (prolog != null) {
                    Collection instructions = PsiTreeUtil.findChildrenOfType((PsiElement)prolog, XmlProcessingInstruction.class);
                    for (XmlProcessingInstruction instruction : instructions) {
                        ASTNode node = instruction.getNode();
                        ASTNode nameNode = node.findChildByType(XmlTokenType.XML_NAME);
                        if (nameNode == null || !nameNode.getText().equals("import")) continue;
                        instruction.delete();
                    }
                    prolog.add((PsiElement)newImportList);
                } else {
                    document.addBefore((PsiElement)newImportList, (PsiElement)document.getRootTag());
                }
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxImportsOptimizer", "processFile"));
        }
        return runnable;
    }

    private static void collectNamesToImport(final @NotNull Collection<Pair<String, Boolean>> names, XmlFile file) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxImportsOptimizer", "collectNamesToImport"));
        }
        file.accept((PsiElementVisitor)new JavaFxUsedClassesVisitor(){

            @Override
            protected void appendClassName(String fqn) {
                names.add(Pair.create((Object)fqn, (Object)false));
            }
        });
    }

    public static abstract class JavaFxUsedClassesVisitor
    extends XmlRecursiveElementVisitor {
        public void visitXmlProlog(XmlProlog prolog) {
        }

        public void visitXmlProcessingInstruction(XmlProcessingInstruction processingInstruction) {
        }

        public void visitXmlAttribute(XmlAttribute attribute) {
            PsiElement declaration;
            XmlAttributeDescriptor descriptor = attribute.getDescriptor();
            if (descriptor instanceof JavaFxStaticPropertyAttributeDescriptor && (declaration = descriptor.getDeclaration()) instanceof PsiMember) {
                this.appendClassName((PsiElement)((PsiMember)declaration).getContainingClass());
            }
        }

        public void visitXmlTag(XmlTag tag) {
            PsiElement declaration;
            super.visitXmlTag(tag);
            XmlElementDescriptor descriptor = tag.getDescriptor();
            if (descriptor instanceof JavaFxClassBackedElementDescriptor) {
                this.appendClassName(descriptor.getDeclaration());
            } else if (descriptor instanceof JavaFxPropertyElementDescriptor && ((JavaFxPropertyElementDescriptor)descriptor).isStatic() && (declaration = descriptor.getDeclaration()) instanceof PsiMember) {
                this.appendClassName((PsiElement)((PsiMember)declaration).getContainingClass());
            }
        }

        private void appendClassName(PsiElement declaration) {
            if (declaration instanceof PsiClass) {
                this.appendClassName(((PsiClass)declaration).getQualifiedName());
            }
        }

        protected abstract void appendClassName(String var1);
    }
}

