/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class JavaFxFileTypeFactory
extends FileTypeFactory {
    public static final String FXML_EXTENSION = "fxml";

    public static boolean isFxml(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/javaFX/fxml/JavaFxFileTypeFactory", "isFxml"));
        }
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        return JavaFxFileTypeFactory.isFxml(virtualFile);
    }

    public static boolean isFxml(@NotNull VirtualFile virtualFile) {
        FileType fileType;
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/javaFX/fxml/JavaFxFileTypeFactory", "isFxml"));
        }
        return FXML_EXTENSION.equals(virtualFile.getExtension()) && (fileType = virtualFile.getFileType()) == FileTypeManager.getInstance().getFileTypeByExtension(FXML_EXTENSION) && !fileType.isBinary();
    }

    public void createFileTypes(@NotNull FileTypeConsumer consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/javaFX/fxml/JavaFxFileTypeFactory", "createFileTypes"));
        }
        FileType fileType = consumer.getStandardFileTypeByName("XML");
        assert (fileType != null);
        consumer.consume(fileType, FXML_EXTENSION);
    }
}

