/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.XmlSchemaProvider;
import java.net.URL;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;

public class JavaFXSchemaHandler
extends XmlSchemaProvider {
    private static final Logger LOG = Logger.getInstance((String)("#" + JavaFXSchemaHandler.class.getName()));

    public boolean isAvailable(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/javaFX/fxml/JavaFXSchemaHandler", "isAvailable"));
        }
        return JavaFxFileTypeFactory.isFxml((PsiFile)file);
    }

    @Nullable
    public XmlFile getSchema(@NotNull @NonNls String url, @Nullable Module module, @NotNull PsiFile baseFile) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/javaFX/fxml/JavaFXSchemaHandler", "getSchema"));
        }
        if (baseFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/javaFX/fxml/JavaFXSchemaHandler", "getSchema"));
        }
        return module != null && JavaFxFileTypeFactory.isFxml(baseFile) ? JavaFXSchemaHandler.getReference(module) : null;
    }

    private static XmlFile getReference(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/javaFX/fxml/JavaFXSchemaHandler", "getReference"));
        }
        URL resource = JavaFXSchemaHandler.class.getResource("fx.xsd");
        VirtualFile fileByURL = VfsUtil.findFileByURL((URL)resource);
        PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(fileByURL);
        LOG.assertTrue(psiFile != null);
        return (XmlFile)psiFile.copy();
    }
}

