/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.ex;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsEventDispatcher;
import org.jetbrains.jps.model.JpsNamedElement;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;

public abstract class JpsNamedCompositeElementBase<Self extends JpsNamedCompositeElementBase<Self>>
extends JpsCompositeElementBase<Self>
implements JpsNamedElement {
    private String myName;

    protected JpsNamedCompositeElementBase(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/ex/JpsNamedCompositeElementBase", "<init>"));
        }
        this.myName = name;
    }

    protected JpsNamedCompositeElementBase(JpsNamedCompositeElementBase<Self> original) {
        super(original);
        this.myName = original.myName;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/ex/JpsNamedCompositeElementBase", "getName"));
        }
        return string;
    }

    @Override
    public void applyChanges(@NotNull Self modified) {
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/ex/JpsNamedCompositeElementBase", "applyChanges"));
        }
        super.applyChanges(modified);
        this.setName(((JpsNamedCompositeElementBase)modified).getName());
    }

    @Override
    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/ex/JpsNamedCompositeElementBase", "setName"));
        }
        if (!this.myName.equals(name)) {
            String oldName = this.myName;
            this.myName = name;
            JpsEventDispatcher eventDispatcher = this.getEventDispatcher();
            if (eventDispatcher != null) {
                eventDispatcher.fireElementRenamed(this, oldName, name);
            }
        }
    }
}

