/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.openapi.extensions.ExtensionPointName;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class HttpRequestHandler {
    public static final ExtensionPointName<HttpRequestHandler> EP_NAME = ExtensionPointName.create((String)"com.intellij.httpRequestHandler");

    public boolean isSupported(FullHttpRequest request) {
        return request.getMethod() == HttpMethod.GET || request.getMethod() == HttpMethod.HEAD;
    }

    public abstract boolean process(QueryStringDecoder var1, FullHttpRequest var2, ChannelHandlerContext var3) throws IOException;

    protected static boolean checkPrefix(@NotNull String uri, @NotNull String prefix) {
        if (uri == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/ide/HttpRequestHandler", "checkPrefix"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/ide/HttpRequestHandler", "checkPrefix"));
        }
        if (uri.length() > prefix.length() && uri.charAt(0) == '/' && uri.regionMatches(true, 1, prefix, 0, prefix.length())) {
            if (uri.length() - prefix.length() == 1) {
                return true;
            }
            char c = uri.charAt(prefix.length() + 1);
            return c == '/' || c == '?';
        }
        return false;
    }
}

