/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlElement;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.IconUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.highlighting.DomCollectionProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.ui.AbstractTableView;
import com.intellij.util.xml.ui.CommitListener;
import com.intellij.util.xml.ui.DomEditorManager;
import com.intellij.util.xml.ui.DomTableView;
import com.intellij.util.xml.ui.DomUIControl;
import com.intellij.util.xml.ui.Highlightable;
import com.intellij.util.xml.ui.actions.AddDomElementAction;
import com.intellij.util.xml.ui.actions.DefaultAddAction;
import java.awt.Container;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomCollectionControl<T extends DomElement>
extends DomUIControl
implements Highlightable,
TypeSafeDataProvider {
    private static final DataKey<DomCollectionControl> DOM_COLLECTION_CONTROL = DataKey.create("DomCollectionControl");
    private final EventDispatcher<CommitListener> myDispatcher = EventDispatcher.create(CommitListener.class);
    private DomTableView myCollectionPanel;
    private final DomElement myParentDomElement;
    private final DomCollectionChildDescription myChildDescription;
    private List<T> myCollectionElements = new ArrayList<T>();
    private ColumnInfo<T, ?>[] myColumnInfos;
    private boolean myEditable = false;
    public static final Icon ADD_ICON = IconUtil.getAddIcon();
    public static final Icon EDIT_ICON = IconUtil.getEditIcon();
    public static final Icon REMOVE_ICON = IconUtil.getRemoveIcon();

    public DomCollectionControl(DomElement parentElement, DomCollectionChildDescription description, boolean editable, ColumnInfo<T, ?> ... columnInfos) {
        this.myChildDescription = description;
        this.myParentDomElement = parentElement;
        this.myColumnInfos = columnInfos;
        this.myEditable = editable;
    }

    public DomCollectionControl(DomElement parentElement, @NonNls String subTagName, boolean editable, ColumnInfo<T, ?> ... columnInfos) {
        this(parentElement, parentElement.getGenericInfo().getCollectionChildDescription(subTagName), editable, columnInfos);
    }

    public DomCollectionControl(DomElement parentElement, DomCollectionChildDescription description) {
        this.myChildDescription = description;
        this.myParentDomElement = parentElement;
    }

    public DomCollectionControl(DomElement parentElement, @NonNls String subTagName) {
        this(parentElement, parentElement.getGenericInfo().getCollectionChildDescription(subTagName));
    }

    public boolean isEditable() {
        return this.myEditable;
    }

    @Override
    public void bind(JComponent component) {
        assert (component instanceof DomTableView);
        this.initialize((DomTableView)component);
    }

    @Override
    public void addCommitListener(CommitListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    @Override
    public void removeCommitListener(CommitListener listener) {
        this.myDispatcher.removeListener((EventListener)listener);
    }

    @Override
    public boolean canNavigate(DomElement element) {
        Class aClass = ReflectionUtil.getRawType((Type)this.myChildDescription.getType());
        Object domElement = element.getParentOfType(aClass, false);
        return domElement != null && this.myCollectionElements.contains(domElement);
    }

    @Override
    public void navigate(DomElement element) {
        Class aClass = ReflectionUtil.getRawType((Type)this.myChildDescription.getType());
        Object domElement = element.getParentOfType(aClass, false);
        int index = this.myCollectionElements.indexOf(domElement);
        if (index < 0) {
            index = 0;
        }
        this.myCollectionPanel.getTable().setRowSelectionInterval(index, index);
    }

    @Override
    public void calcData(DataKey key, DataSink sink) {
        if (DOM_COLLECTION_CONTROL.equals(key)) {
            sink.put(DOM_COLLECTION_CONTROL, this);
        }
    }

    @Nullable
    protected String getHelpId() {
        return null;
    }

    @Nullable
    protected String getEmptyPaneText() {
        return null;
    }

    protected void initialize(DomTableView boundComponent) {
        this.myCollectionPanel = boundComponent == null ? new DomTableView(this.getProject(), this.getEmptyPaneText(), this.getHelpId()) : boundComponent;
        this.myCollectionPanel.setToolbarActions(new AddAction(), new EditAction(), new RemoveAction());
        this.myCollectionPanel.installPopup("J2EEAttributesViewPopup", this.createPopupActionGroup());
        this.myCollectionPanel.initializeTable();
        this.myCollectionPanel.addCustomDataProvider(this);
        this.myCollectionPanel.addChangeListener(new AbstractTableView.ChangeListener(){

            @Override
            public void changed() {
                DomCollectionControl.this.reset();
            }
        });
        this.reset();
    }

    protected DefaultActionGroup createPopupActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.addAll((DefaultActionGroup)ActionManager.getInstance().getAction("DomCollectionControl"));
        return group;
    }

    protected ColumnInfo[] createColumnInfos(DomElement parent) {
        return this.myColumnInfos;
    }

    protected final void doEdit() {
        this.doEdit((DomElement)this.myCollectionElements.get(this.myCollectionPanel.getTable().getSelectedRow()));
    }

    protected void doEdit(T t) {
        DomEditorManager manager = DomCollectionControl.getDomEditorManager(this);
        if (manager != null) {
            manager.openDomElementEditor((DomElement)t);
        }
    }

    protected void doRemove(final List<T> toDelete) {
        HashSet files = new HashSet();
        for (DomElement t : toDelete) {
            XmlElement element = t.getXmlElement();
            if (element == null) continue;
            ContainerUtil.addIfNotNull((Object)element.getContainingFile(), (Collection)files);
        }
        new WriteCommandAction(this.getProject(), PsiUtilCore.toPsiFileArray((Collection<? extends PsiFile>)files)){

            @Override
            protected void run(Result result) throws Throwable {
                for (DomElement t : toDelete) {
                    if (!t.isValid()) continue;
                    t.undefine();
                }
            }
        }.execute();
    }

    protected final void doRemove() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                int[] selected = DomCollectionControl.this.myCollectionPanel.getTable().getSelectedRows();
                if (selected == null || selected.length == 0) {
                    return;
                }
                ArrayList selectedElements = new ArrayList(selected.length);
                for (int i : selected) {
                    selectedElements.add(DomCollectionControl.this.myCollectionElements.get(i));
                }
                DomCollectionControl.this.doRemove(selectedElements);
                DomCollectionControl.this.reset();
                int selection = selected[0];
                if (selection >= DomCollectionControl.this.myCollectionElements.size()) {
                    selection = DomCollectionControl.this.myCollectionElements.size() - 1;
                }
                if (selection >= 0) {
                    DomCollectionControl.this.myCollectionPanel.getTable().setRowSelectionInterval(selection, selection);
                }
            }
        });
    }

    protected static void performWriteCommandAction(WriteCommandAction writeCommandAction) {
        writeCommandAction.execute();
    }

    @Override
    public void commit() {
        CommitListener listener = (CommitListener)this.myDispatcher.getMulticaster();
        listener.beforeCommit(this);
        listener.afterCommit(this);
        this.validate();
    }

    private void validate() {
        DomElement domElement = this.getDomElement();
        List<DomElementProblemDescriptor> list = DomElementAnnotationsManager.getInstance(this.getProject()).getCachedProblemHolder(domElement).getProblems(domElement);
        ArrayList<String> messages = new ArrayList<String>();
        for (DomElementProblemDescriptor descriptor : list) {
            if (!(descriptor instanceof DomCollectionProblemDescriptor) || !this.myChildDescription.equals(((DomCollectionProblemDescriptor)descriptor).getChildDescription())) continue;
            messages.add(descriptor.getDescriptionTemplate());
        }
        this.myCollectionPanel.setErrorMessages(ArrayUtil.toStringArray(messages));
        this.myCollectionPanel.repaint();
    }

    public void dispose() {
        if (this.myCollectionPanel != null) {
            this.myCollectionPanel.dispose();
        }
    }

    protected final Project getProject() {
        return this.myParentDomElement.getManager().getProject();
    }

    @Override
    public DomTableView getComponent() {
        if (this.myCollectionPanel == null) {
            this.initialize(null);
        }
        return this.myCollectionPanel;
    }

    public final DomCollectionChildDescription getChildDescription() {
        return this.myChildDescription;
    }

    public final DomElement getDomElement() {
        return this.myParentDomElement;
    }

    @Override
    public final void reset() {
        this.myCollectionElements = new ArrayList<T>(this.getCollectionElements());
        this.myCollectionPanel.reset(this.createColumnInfos(this.myParentDomElement), this.myCollectionElements);
        this.validate();
    }

    public List<T> getCollectionElements() {
        return this.myChildDescription.getValues(this.myParentDomElement);
    }

    @Nullable
    protected AnAction[] createAdditionActions() {
        return null;
    }

    protected DefaultAddAction createDefaultAction(String name, Icon icon, final Type type) {
        return new ControlAddAction(name, name, icon){

            @Override
            protected Type getElementType() {
                return type;
            }
        };
    }

    protected final Class<? extends T> getCollectionElementClass() {
        return ReflectionUtil.getRawType((Type)this.myChildDescription.getType());
    }

    @Nullable
    private static DomEditorManager getDomEditorManager(DomUIControl control) {
        JComponent component = control.getComponent();
        while (component != null && !(component instanceof DomEditorManager)) {
            Container parent = component.getParent();
            if (!(parent instanceof JComponent)) {
                return null;
            }
            component = (JComponent)parent;
        }
        return (DomEditorManager)((Object)component);
    }

    @Override
    public void updateHighlighting() {
        if (this.myCollectionPanel != null) {
            this.myCollectionPanel.revalidate();
            this.myCollectionPanel.repaint();
        }
    }

    public static DomCollectionControl getDomCollectionControl(AnActionEvent e) {
        return e.getData(DOM_COLLECTION_CONTROL);
    }

    public static class RemoveAction
    extends AnAction {
        public RemoveAction() {
            super(ApplicationBundle.message("action.remove", new Object[0]), null, REMOVE_ICON);
            this.setShortcutSet(CommonActionsPanel.getCommonShortcut(CommonActionsPanel.Buttons.REMOVE));
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            DomCollectionControl control = DomCollectionControl.getDomCollectionControl(e);
            control.doRemove();
            control.reset();
        }

        @Override
        public void update(AnActionEvent e) {
            JTable table;
            DomCollectionControl control = DomCollectionControl.getDomCollectionControl(e);
            boolean enabled = control != null ? (table = control.getComponent().getTable()) != null && table.getSelectedRowCount() > 0 : false;
            e.getPresentation().setEnabled(enabled);
        }
    }

    public static class EditAction
    extends AnAction {
        public EditAction() {
            super(ApplicationBundle.message("action.edit", new Object[0]), null, EDIT_ICON);
            this.setShortcutSet(CommonActionsPanel.getCommonShortcut(CommonActionsPanel.Buttons.EDIT));
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            DomCollectionControl control = DomCollectionControl.getDomCollectionControl(e);
            control.doEdit();
            control.reset();
        }

        @Override
        public void update(AnActionEvent e) {
            DomCollectionControl control = DomCollectionControl.getDomCollectionControl(e);
            boolean visible = control != null && control.isEditable();
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && control.getComponent().getTable().getSelectedRowCount() == 1);
        }
    }

    public static class AddAction
    extends AddDomElementAction {
        public AddAction() {
            this.setShortcutSet(CommonActionsPanel.getCommonShortcut(CommonActionsPanel.Buttons.ADD));
        }

        @Override
        protected boolean isEnabled(AnActionEvent e) {
            return this.getDomCollectionControl(e) != null;
        }

        protected DomCollectionControl getDomCollectionControl(AnActionEvent e) {
            return DomCollectionControl.getDomCollectionControl(e);
        }

        @Override
        @NotNull
        protected DomCollectionChildDescription[] getDomCollectionChildDescriptions(AnActionEvent e) {
            DomCollectionChildDescription[] domCollectionChildDescriptionArray = new DomCollectionChildDescription[]{this.getDomCollectionControl(e).getChildDescription()};
            if (domCollectionChildDescriptionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ui/DomCollectionControl$AddAction", "getDomCollectionChildDescriptions"));
            }
            return domCollectionChildDescriptionArray;
        }

        @Override
        protected DomElement getParentDomElement(AnActionEvent e) {
            return this.getDomCollectionControl(e).getDomElement();
        }

        @Override
        protected JComponent getComponent(AnActionEvent e) {
            return this.getDomCollectionControl(e).getComponent();
        }

        @Override
        @NotNull
        public AnAction[] getChildren(AnActionEvent e) {
            DomCollectionControl control = this.getDomCollectionControl(e);
            AnAction[] actions = control.createAdditionActions();
            AnAction[] anActionArray = actions == null ? super.getChildren(e) : actions;
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ui/DomCollectionControl$AddAction", "getChildren"));
            }
            return anActionArray;
        }

        @Override
        protected DefaultAddAction createAddingAction(AnActionEvent e, String name, Icon icon, Type type, DomCollectionChildDescription description) {
            return this.getDomCollectionControl(e).createDefaultAction(name, icon, type);
        }
    }

    public class ControlAddAction
    extends DefaultAddAction<T> {
        public ControlAddAction() {
        }

        public ControlAddAction(String text) {
            super(text);
        }

        public ControlAddAction(String text, String description, Icon icon) {
            super(text, description, icon);
        }

        @Override
        protected final DomCollectionChildDescription getDomCollectionChildDescription() {
            return DomCollectionControl.this.myChildDescription;
        }

        @Override
        protected final DomElement getParentDomElement() {
            return DomCollectionControl.this.myParentDomElement;
        }

        protected int getColumnToEditAfterAddition() {
            return 0;
        }

        protected void afterAddition(JTable table, int rowIndex) {
            table.setRowSelectionInterval(rowIndex, rowIndex);
            int column = this.getColumnToEditAfterAddition();
            if (column >= 0) {
                table.editCellAt(rowIndex, column);
            }
        }

        @Override
        protected final void afterAddition(T newElement) {
            DomCollectionControl.this.reset();
            this.afterAddition(DomCollectionControl.this.myCollectionPanel.getTable(), DomCollectionControl.this.myCollectionElements.size() - 1);
        }
    }
}

