/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.model.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ModelMerger;
import com.intellij.util.xml.model.DomModel;
import com.intellij.util.xml.model.DomModelCache;
import com.intellij.util.xml.model.impl.CachedDomModelFactory;
import com.intellij.util.xml.model.impl.SimpleDomModelFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CachedSimpleDomModelFactory<T extends DomElement, M extends DomModel<T>, Scope extends UserDataHolder>
extends SimpleDomModelFactory<T, M>
implements CachedDomModelFactory<T, M, Scope> {
    private final DomModelCache<M, XmlFile> myModelCache;

    protected CachedSimpleDomModelFactory(@NotNull Class<T> aClass, @NotNull ModelMerger modelMerger, Project project, @NonNls String name) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/model/impl/CachedSimpleDomModelFactory", "<init>"));
        }
        if (modelMerger == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/xml/model/impl/CachedSimpleDomModelFactory", "<init>"));
        }
        super(aClass, modelMerger);
        this.myModelCache = new DomModelCache<M, XmlFile>(project, name + " model"){

            @Override
            @NotNull
            protected CachedValueProvider.Result<M> computeValue(@NotNull XmlFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/model/impl/CachedSimpleDomModelFactory$1", "computeValue"));
                }
                file = (XmlFile)file.getOriginalFile();
                Object scope = CachedSimpleDomModelFactory.this.getModelScope(file);
                Object model = CachedSimpleDomModelFactory.this.computeModel(file, scope);
                CachedValueProvider.Result result = new CachedValueProvider.Result(model, CachedSimpleDomModelFactory.this.computeDependencies(model, scope));
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/model/impl/CachedSimpleDomModelFactory$1", "computeValue"));
                }
                return result;
            }
        };
    }

    @Override
    @Nullable
    public M getModelByConfigFile(@Nullable XmlFile psiFile) {
        if (psiFile == null) {
            return null;
        }
        return (M)((DomModel)this.myModelCache.getCachedValue(psiFile));
    }

    @Nullable
    protected abstract M computeModel(@NotNull XmlFile var1, @Nullable Scope var2);
}

