/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters;

import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathReferenceConverter
extends Converter<PathReference>
implements CustomReferenceConverter {
    public static final Converter<PathReference> INSTANCE = new PathReferenceConverter();

    @Override
    public PathReference fromString(@Nullable String s, ConvertContext context) {
        XmlElement element = context.getXmlElement();
        return s == null || element == null ? null : PathReferenceManager.getInstance().getPathReference(s, element, new PathReferenceProvider[0]);
    }

    @Override
    public String toString(PathReference t, ConvertContext context) {
        return t == null ? null : t.getPath();
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        PsiReference[] psiReferenceArray = this.createReferences(element, true);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/converters/PathReferenceConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    @NotNull
    public PsiReference[] createReferences(@NotNull PsiElement psiElement, boolean soft) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/converters/PathReferenceConverter", "createReferences"));
        }
        PsiReference[] psiReferenceArray = PathReferenceManager.getInstance().createReferences(psiElement, soft, new PathReferenceProvider[0]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/converters/PathReferenceConverter", "createReferences"));
        }
        return psiReferenceArray;
    }
}

