/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.xml.DomElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomJavaUtil {
    private DomJavaUtil() {
    }

    @Nullable
    public static PsiClass findClass(@Nullable String name, @NotNull PsiFile file, @Nullable Module module, @Nullable GlobalSearchScope searchScope) {
        GlobalSearchScope scope;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/xml/DomJavaUtil", "findClass"));
        }
        if (name == null) {
            return null;
        }
        if (name.indexOf(36) >= 0) {
            name = name.replace('$', '.');
        }
        if (searchScope == null) {
            if (module != null) {
                VirtualFile virtualFile = (file = file.getOriginalFile()).getVirtualFile();
                if (virtualFile == null) {
                    scope = GlobalSearchScope.moduleRuntimeScope(module, true);
                } else {
                    ProjectFileIndex fileIndex = ProjectRootManager.getInstance(file.getProject()).getFileIndex();
                    boolean tests = fileIndex.isInTestSourceContent(virtualFile);
                    scope = module.getModuleRuntimeScope(tests);
                }
            } else {
                scope = file.getResolveScope();
            }
        } else {
            scope = searchScope;
        }
        PsiClass aClass = JavaPsiFacade.getInstance(file.getProject()).findClass(name, scope);
        if (aClass != null) assert (aClass.isValid()) : name;
        return aClass;
    }

    @Nullable
    public static PsiClass findClass(@Nullable String name, @NotNull DomElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/xml/DomJavaUtil", "findClass"));
        }
        assert (element.isValid());
        XmlElement xmlElement = element.getXmlElement();
        if (xmlElement != null) {
            assert (xmlElement.isValid());
            return DomJavaUtil.findClass(name, xmlElement.getContainingFile(), element.getModule(), element.getResolveScope());
        }
        return null;
    }
}

