/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.MappingClass;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ClassMappingNameConverter
extends ResolvingConverter.StringConverter {
    @Override
    @NotNull
    public Collection<? extends String> getVariants(ConvertContext context) {
        DomElement parent = context.getInvocationElement().getParent();
        assert (parent != null);
        List<DomElement> children = DomUtil.getDefinedChildren(parent, true, true);
        DomElement classElement = (DomElement)ContainerUtil.find(children, (Condition)new Condition<DomElement>(){

            public boolean value(DomElement domElement) {
                return domElement.getAnnotation(MappingClass.class) != null;
            }
        });
        if (classElement == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ClassMappingNameConverter", "getVariants"));
            }
            return list;
        }
        Object value = ((GenericDomValue)classElement).getValue();
        if (value == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ClassMappingNameConverter", "getVariants"));
            }
            return list;
        }
        assert (value instanceof PsiClass) : classElement + " should have PsiClass type, but was " + value;
        PsiClass psiClass = (PsiClass)value;
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(context.getProject());
        PsiClassType classType = PsiTypesUtil.getClassType(psiClass);
        SuggestedNameInfo info = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, classType);
        List<String> list = Arrays.asList(info.names);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ClassMappingNameConverter", "getVariants"));
        }
        return list;
    }

    @Override
    public PsiElement resolve(String o, ConvertContext context) {
        DomElement parent = context.getInvocationElement().getParent();
        assert (parent != null);
        return parent.getXmlElement();
    }
}

