/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.ClickListener;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.UIBundle;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StatusText {
    public static final SimpleTextAttributes DEFAULT_ATTRIBUTES = SimpleTextAttributes.GRAYED_ATTRIBUTES;
    public static final String DEFAULT_EMPTY_TEXT = UIBundle.message((String)"message.nothingToShow", (Object[])new Object[0]);
    @Nullable
    private Component myOwner;
    private Component myMouseTarget;
    private final MouseMotionListener myMouseMotionListener;
    private final ClickListener myClickListener;
    private boolean myIsDefaultText;
    private String myText = "";
    protected final SimpleColoredComponent myComponent = new SimpleColoredComponent();
    private final ArrayList<ActionListener> myClickListeners = new ArrayList();

    protected StatusText(JComponent owner) {
        this();
        this.attachTo(owner);
    }

    public StatusText() {
        this.myClickListener = new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                ActionListener actionListener;
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ui/StatusText$1", "onClick"));
                }
                if (e.getButton() == 1 && clickCount == 1 && (actionListener = StatusText.this.findActionListenerAt(e.getPoint())) != null) {
                    actionListener.actionPerformed(new ActionEvent((Object)this, 0, ""));
                    return true;
                }
                return false;
            }
        };
        this.myMouseMotionListener = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (StatusText.this.isStatusVisible()) {
                    if (StatusText.this.findActionListenerAt(e.getPoint()) != null) {
                        StatusText.this.myMouseTarget.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        StatusText.this.myMouseTarget.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        };
        this.myComponent.setOpaque(false);
        this.myComponent.setFont(UIUtil.getLabelFont());
        this.setText(DEFAULT_EMPTY_TEXT, DEFAULT_ATTRIBUTES);
        this.myIsDefaultText = true;
    }

    public void attachTo(@Nullable Component owner) {
        this.attachTo(owner, owner);
    }

    public void attachTo(@Nullable Component owner, @Nullable Component mouseTarget) {
        if (this.myMouseTarget != null) {
            this.myClickListener.uninstall(this.myMouseTarget);
            this.myMouseTarget.removeMouseMotionListener(this.myMouseMotionListener);
        }
        this.myOwner = owner;
        this.myMouseTarget = mouseTarget;
        if (this.myMouseTarget != null) {
            this.myClickListener.installOn(this.myMouseTarget);
            this.myMouseTarget.addMouseMotionListener(this.myMouseMotionListener);
        }
    }

    protected abstract boolean isStatusVisible();

    @Nullable
    private ActionListener findActionListenerAt(Point point) {
        int index;
        if (!this.isStatusVisible()) {
            return null;
        }
        point = SwingUtilities.convertPoint(this.myMouseTarget, point, this.myOwner);
        Rectangle b = this.getTextComponentBound();
        if (b.contains(point) && (index = this.myComponent.findFragmentAt(point.x - b.x)) >= 0 && index < this.myClickListeners.size()) {
            return this.myClickListeners.get(index);
        }
        return null;
    }

    protected Rectangle getTextComponentBound() {
        Rectangle ownerRec = this.myOwner == null ? new Rectangle(0, 0, 0, 0) : this.myOwner.getBounds();
        Dimension size = this.myComponent.getPreferredSize();
        int x = (ownerRec.width - size.width) / 2;
        int y = (ownerRec.height - size.height) / 3;
        return new Rectangle(x, y, size.width, size.height);
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/StatusText", "getText"));
        }
        return string;
    }

    public StatusText setText(String text) {
        return this.setText(text, DEFAULT_ATTRIBUTES);
    }

    public StatusText setText(String text, SimpleTextAttributes attrs) {
        return this.clear().appendText(text, attrs);
    }

    public StatusText clear() {
        this.myText = "";
        this.myComponent.clear();
        this.myClickListeners.clear();
        if (this.myOwner != null) {
            this.myOwner.repaint();
        }
        return this;
    }

    public StatusText appendText(String text) {
        return this.appendText(text, DEFAULT_ATTRIBUTES);
    }

    public StatusText appendText(String text, SimpleTextAttributes attrs) {
        return this.appendText(text, attrs, null);
    }

    public StatusText appendText(String text, SimpleTextAttributes attrs, ActionListener listener) {
        if (this.myIsDefaultText) {
            this.clear();
            this.myIsDefaultText = false;
        }
        this.myText = this.myText + text;
        this.myComponent.append(text, attrs);
        this.myClickListeners.add(listener);
        if (this.myOwner != null) {
            this.myOwner.repaint();
        }
        return this;
    }

    public void paint(Component owner, Graphics g) {
        if (!this.isStatusVisible() || owner != this.myOwner) {
            return;
        }
        Rectangle b = this.getTextComponentBound();
        this.myComponent.setBounds(0, 0, b.width, b.height);
        Graphics2D g2 = (Graphics2D)g.create(b.x, b.y, b.width, b.height);
        this.myComponent.paint(g2);
        g2.dispose();
    }

    @NotNull
    public SimpleColoredComponent getComponent() {
        SimpleColoredComponent simpleColoredComponent = this.myComponent;
        if (simpleColoredComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/StatusText", "getComponent"));
        }
        return simpleColoredComponent;
    }

    public Dimension getPreferredSize() {
        return this.myComponent.getPreferredSize();
    }
}

