/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Robot;
import java.awt.TextComponent;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class JTableCellEditorHelper {
    private JTableCellEditorHelper() {
    }

    public static void typeAhead(final JTable table, final EventObject e, final int row, final int column) {
        if (e instanceof KeyEvent) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (table.getEditingColumn() != column && table.getEditingRow() != row) {
                        return;
                    }
                    Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    if (focusOwner == null || !SwingUtilities.isDescendingFrom(focusOwner, table)) {
                        return;
                    }
                    KeyEvent keyEvent = (KeyEvent)e;
                    if (Character.isDefined(keyEvent.getKeyChar())) {
                        try {
                            JTableCellEditorHelper.selectAll(focusOwner);
                            Robot r = new Robot();
                            r.keyPress(keyEvent.getKeyCode());
                            r.keyRelease(keyEvent.getKeyCode());
                        }
                        catch (AWTException e1) {
                            return;
                        }
                    } else {
                        JTableCellEditorHelper.selectAll(focusOwner);
                    }
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    private static void selectAll(Component component) {
        if (component instanceof TextComponent) {
            ((TextComponent)component).selectAll();
        } else {
            Editor editor = CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext(component));
            if (editor != null) {
                editor.getSelectionModel().setSelection(0, editor.getDocument().getTextLength());
            }
        }
    }
}

