/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormBuilder {
    private boolean myAlignLabelOnRight = false;
    private int myLineCount = 0;
    private int myIndent = 0;
    private final JPanel myPanel = new JPanel(new GridBagLayout());
    private boolean myVertical = false;
    private int myVerticalGap = 4;
    private int myHorizontalGap = 10;

    public static FormBuilder createFormBuilder() {
        return new FormBuilder();
    }

    public FormBuilder addLabeledComponent(@Nullable JComponent label, @NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/ui/FormBuilder", "addLabeledComponent"));
        }
        return this.addLabeledComponent(label, component, this.myVerticalGap, false);
    }

    public FormBuilder addLabeledComponent(@Nullable JComponent label, @NotNull JComponent component, int topInset) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/ui/FormBuilder", "addLabeledComponent"));
        }
        return this.addLabeledComponent(label, component, topInset, false);
    }

    public FormBuilder addLabeledComponent(@Nullable JComponent label, @NotNull JComponent component, boolean labelOnTop) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/ui/FormBuilder", "addLabeledComponent"));
        }
        return this.addLabeledComponent(label, component, this.myVerticalGap, labelOnTop);
    }

    public FormBuilder addLabeledComponent(@NotNull String labelText, @NotNull JComponent component) {
        if (labelText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ui/FormBuilder", "addLabeledComponent"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/ui/FormBuilder", "addLabeledComponent"));
        }
        return this.addLabeledComponent(labelText, component, this.myVerticalGap, false);
    }

    public FormBuilder addLabeledComponent(@NotNull String labelText, @NotNull JComponent component, int topInset) {
        if (labelText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ui/FormBuilder", "addLabeledComponent"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/ui/FormBuilder", "addLabeledComponent"));
        }
        return this.addLabeledComponent(labelText, component, topInset, false);
    }

    public FormBuilder addLabeledComponent(@NotNull String labelText, @NotNull JComponent component, boolean labelOnTop) {
        if (labelText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ui/FormBuilder", "addLabeledComponent"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/ui/FormBuilder", "addLabeledComponent"));
        }
        return this.addLabeledComponent(labelText, component, this.myVerticalGap, labelOnTop);
    }

    public FormBuilder addLabeledComponent(@NotNull String labelText, @NotNull JComponent component, int topInset, boolean labelOnTop) {
        if (labelText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ui/FormBuilder", "addLabeledComponent"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/ui/FormBuilder", "addLabeledComponent"));
        }
        JLabel label = new JLabel(UIUtil.removeMnemonic((String)labelText));
        int index = UIUtil.getDisplayMnemonicIndex((String)labelText);
        if (index != -1) {
            label.setDisplayedMnemonic(labelText.charAt(index + 1));
        }
        label.setLabelFor(component);
        return this.addLabeledComponent(label, component, topInset, labelOnTop);
    }

    public FormBuilder addComponent(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ui/FormBuilder", "addComponent"));
        }
        return this.addLabeledComponent((JComponent)null, component, this.myVerticalGap, false);
    }

    public FormBuilder addComponent(@NotNull JComponent component, int topInset) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ui/FormBuilder", "addComponent"));
        }
        return this.addLabeledComponent((JComponent)null, component, topInset, false);
    }

    public FormBuilder addSeparator(int topInset) {
        return this.addComponent(new JSeparator(), topInset);
    }

    public FormBuilder addSeparator() {
        return this.addSeparator(this.myVerticalGap);
    }

    public FormBuilder addVerticalGap(int height) {
        return this.addLabeledComponent((JComponent)null, (JComponent)new Box.Filler(new Dimension(0, height), new Dimension(0, height), new Dimension(Short.MAX_VALUE, height)));
    }

    public FormBuilder addTooltip(String text) {
        JBLabel label = new JBLabel(text, UIUtil.ComponentStyle.SMALL, UIUtil.FontColor.BRIGHTER);
        label.setBorder(new EmptyBorder(0, 10, 0, 0));
        return this.addComponentToRightColumn(label, 1);
    }

    public FormBuilder addComponentToRightColumn(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ui/FormBuilder", "addComponentToRightColumn"));
        }
        return this.addComponentToRightColumn(component, this.myVerticalGap);
    }

    public FormBuilder addComponentToRightColumn(@NotNull JComponent component, int topInset) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ui/FormBuilder", "addComponentToRightColumn"));
        }
        return this.addLabeledComponent((JComponent)new JLabel(), component, topInset);
    }

    public FormBuilder addLabeledComponent(@Nullable JComponent label, @NotNull JComponent component, int topInset, boolean labelOnTop) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/ui/FormBuilder", "addLabeledComponent"));
        }
        GridBagConstraints c = new GridBagConstraints();
        int n = topInset = this.myLineCount > 0 ? topInset : 0;
        if (this.myVertical || labelOnTop || label == null) {
            c.gridwidth = 2;
            c.gridx = 0;
            c.gridy = this.myLineCount;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 0;
            c.anchor = this.getLabelAnchor(component, false);
            c.insets = new Insets(topInset, this.myIndent, 4, 0);
            if (label != null) {
                this.myPanel.add((Component)label, c);
            }
            c.gridx = 0;
            c.gridy = this.myLineCount + 1;
            c.weightx = 1.0;
            c.weighty = FormBuilder.getWeightY(component);
            c.fill = this.getFill(component);
            c.anchor = 17;
            c.insets = new Insets(label == null ? topInset : 0, this.myIndent, 0, 0);
            this.myPanel.add((Component)component, c);
            this.myLineCount += 2;
        } else {
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = this.myLineCount++;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 0;
            c.anchor = this.getLabelAnchor(component, true);
            c.insets = new Insets(topInset, this.myIndent, 0, this.myHorizontalGap);
            this.myPanel.add((Component)label, c);
            c.gridx = 1;
            c.weightx = 1.0;
            c.weighty = FormBuilder.getWeightY(component);
            c.fill = this.getFill(component);
            c.anchor = 17;
            c.insets = new Insets(topInset, this.myIndent, 0, 0);
            this.myPanel.add((Component)component, c);
        }
        return this;
    }

    private int getLabelAnchor(JComponent component, boolean honorAlignment) {
        if (component instanceof JScrollPane) {
            return honorAlignment && this.myAlignLabelOnRight ? 12 : 18;
        }
        return honorAlignment && this.myAlignLabelOnRight ? 13 : 17;
    }

    protected int getFill(JComponent component) {
        if (component instanceof JComboBox || component instanceof JSpinner) {
            return 0;
        }
        if (component instanceof JScrollPane) {
            return 1;
        }
        if (component instanceof JTextField && ((JTextField)component).getColumns() != 0) {
            return 0;
        }
        return 2;
    }

    private static int getWeightY(JComponent component) {
        if (component instanceof JScrollPane) {
            return 1;
        }
        return 0;
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    public int getLineCount() {
        return this.myLineCount;
    }

    public FormBuilder setAlignLabelOnRight(boolean alignLabelOnRight) {
        this.myAlignLabelOnRight = alignLabelOnRight;
        return this;
    }

    public FormBuilder setVertical(boolean vertical) {
        this.myVertical = vertical;
        return this;
    }

    public FormBuilder setVerticalGap(int verticalGap) {
        this.myVerticalGap = verticalGap;
        return this;
    }

    public FormBuilder setHorizontalGap(int horizontalGap) {
        this.myHorizontalGap = horizontalGap;
        return this;
    }

    public FormBuilder setIndent(int indent) {
        this.myIndent = indent;
        return this;
    }
}

