/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.GuiUtils;
import com.intellij.util.net.HTTPProxySettingsDialog;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IOExceptionDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(IOExceptionDialog.class);
    private JTextArea myErrorLabel;

    public IOExceptionDialog(String title, String errorText) {
        super((Project)null, true);
        this.setTitle(title);
        this.setOKButtonText(CommonBundle.message((String)"dialog.ioexception.tryagain", (Object[])new Object[0]));
        this.myErrorLabel = new JTextArea();
        this.myErrorLabel.setText(errorText);
        this.myErrorLabel.setFont(UIManager.getFont("Label.font"));
        this.myErrorLabel.setBackground(UIManager.getColor("Label.background"));
        this.myErrorLabel.setForeground(UIManager.getColor("Label.foreground"));
        this.init();
    }

    @Override
    @Nullable
    protected JComponent createCenterPanel() {
        return this.myErrorLabel;
    }

    @Override
    @NotNull
    protected Action[] createLeftSideActions() {
        Action[] actionArray = new Action[]{new AbstractAction(CommonBundle.message((String)"dialog.ioexception.proxy", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                new HTTPProxySettingsDialog().show();
            }
        }};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/IOExceptionDialog", "createLeftSideActions"));
        }
        return actionArray;
    }

    public static boolean showErrorDialog(final String title, final String text) {
        final Ref ok = Ref.create((Object)false);
        try {
            Runnable doRun = new Runnable(){

                @Override
                public void run() {
                    IOExceptionDialog dialog = new IOExceptionDialog(title, text);
                    dialog.show();
                    ok.set((Object)dialog.isOK());
                }
            };
            GuiUtils.runOrInvokeAndWait(doRun);
        }
        catch (InterruptedException e) {
            LOG.info((Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.info((Throwable)e);
        }
        return (Boolean)ok.get();
    }
}

