/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.KeyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.StaticGetter;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.net.AuthenticationDialog;
import com.intellij.util.net.AuthenticationPanel;
import com.intellij.util.net.HTTPProxySettingsPanel;
import com.intellij.util.net.IdeaWideAuthenticator;
import com.intellij.util.net.IdeaWideProxySelector;
import com.intellij.util.proxy.CommonProxy;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.commons.codec.binary.Base64;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="HttpConfigurable", storages={@Storage(file="$APP_CONFIG$/other.xml")})
public class HttpConfigurable
implements PersistentStateComponent<HttpConfigurable>,
ApplicationComponent,
JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.net.HttpConfigurable");
    public boolean PROXY_TYPE_IS_SOCKS = false;
    public boolean USE_HTTP_PROXY = false;
    public boolean USE_PROXY_PAC = false;
    public volatile transient boolean AUTHENTICATION_CANCELLED = false;
    public String PROXY_HOST = "";
    public int PROXY_PORT = 80;
    public volatile boolean PROXY_AUTHENTICATION = false;
    public volatile String PROXY_LOGIN = "";
    public volatile String PROXY_PASSWORD_CRYPT = "";
    public boolean KEEP_PROXY_PASSWORD = false;
    public transient String LAST_ERROR;
    public Map<CommonProxy.HostInfo, ProxyInfo> myGenericPasswords = new HashMap<CommonProxy.HostInfo, ProxyInfo>();
    public Set<CommonProxy.HostInfo> myGenericCancelled = new HashSet<CommonProxy.HostInfo>();
    private final transient Object myLock = new Object();
    private IdeaWideProxySelector mySelector;
    private IdeaWideAuthenticator myAuthenticator;
    public transient Getter<PasswordAuthentication> myTestAuthRunnable = new StaticGetter(null);
    public transient Getter<PasswordAuthentication> myTestGenericAuthRunnable = new StaticGetter(null);
    public String PROXY_EXCEPTIONS = "";
    public boolean USE_PAC_URL = false;
    public String PAC_URL = "";

    public static HttpConfigurable getInstance() {
        return ServiceManager.getService(HttpConfigurable.class);
    }

    public static boolean editConfigurable(JComponent parent) {
        return ShowSettingsUtil.getInstance().editConfigurable(parent, (Configurable)new HTTPProxySettingsPanel(HttpConfigurable.getInstance()));
    }

    @Override
    public HttpConfigurable getState() {
        HttpConfigurable state = new HttpConfigurable();
        XmlSerializerUtil.copyBean((Object)this, (Object)state);
        if (!this.KEEP_PROXY_PASSWORD) {
            state.PROXY_PASSWORD_CRYPT = "";
        }
        this.correctPasswords(this, state);
        return state;
    }

    @Override
    public void initComponent() {
        this.mySelector = new IdeaWideProxySelector(this);
        this.myAuthenticator = new IdeaWideAuthenticator(this);
        String name = this.getClass().getName();
        CommonProxy.getInstance().setCustom(name, this.mySelector);
        CommonProxy.getInstance().setCustomAuth(name, this.myAuthenticator);
    }

    @NotNull
    public ProxySelector getOnlyBySettingsSelector() {
        IdeaWideProxySelector ideaWideProxySelector = this.mySelector;
        if (ideaWideProxySelector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/HttpConfigurable", "getOnlyBySettingsSelector"));
        }
        return ideaWideProxySelector;
    }

    @Override
    public void disposeComponent() {
        String name = this.getClass().getName();
        CommonProxy.getInstance().removeCustom(name);
        CommonProxy.getInstance().removeCustomAuth(name);
    }

    @Override
    @NotNull
    public String getComponentName() {
        String string = this.getClass().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/HttpConfigurable", "getComponentName"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void correctPasswords(HttpConfigurable from, HttpConfigurable to) {
        Object object = this.myLock;
        synchronized (object) {
            to.myGenericPasswords = new HashMap<CommonProxy.HostInfo, ProxyInfo>();
            for (Map.Entry<CommonProxy.HostInfo, ProxyInfo> entry : from.myGenericPasswords.entrySet()) {
                if (!Boolean.TRUE.equals(entry.getValue().isStore())) continue;
                to.myGenericPasswords.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void loadState(HttpConfigurable state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
        if (!this.KEEP_PROXY_PASSWORD) {
            this.PROXY_PASSWORD_CRYPT = "";
        }
        this.correctPasswords(state, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGenericPasswordCanceled(String host, int port) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myGenericCancelled.contains(Pair.create((Object)host, (Object)port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGenericPasswordCanceled(String host, int port) {
        Object object = this.myLock;
        synchronized (object) {
            this.myGenericCancelled.add(new CommonProxy.HostInfo("", host, port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PasswordAuthentication getGenericPassword(String host, int port) {
        ProxyInfo proxyInfo;
        Object object = this.myLock;
        synchronized (object) {
            proxyInfo = this.myGenericPasswords.get(new CommonProxy.HostInfo("", host, port));
        }
        if (proxyInfo == null) {
            return null;
        }
        return new PasswordAuthentication(proxyInfo.getUsername(), this.decode(String.valueOf(proxyInfo.getPasswordCrypt())).toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putGenericPassword(String host, int port, PasswordAuthentication authentication, boolean remember) {
        PasswordAuthentication coded = new PasswordAuthentication(authentication.getUserName(), this.encode(String.valueOf(authentication.getPassword())).toCharArray());
        Object object = this.myLock;
        synchronized (object) {
            this.myGenericPasswords.put(new CommonProxy.HostInfo("", host, port), new ProxyInfo(remember, coded.getUserName(), String.valueOf(coded.getPassword())));
        }
    }

    @Transient
    public String getPlainProxyPassword() {
        return this.decode(this.PROXY_PASSWORD_CRYPT);
    }

    private String decode(String value) {
        return new String(new Base64().decode(value.getBytes()));
    }

    @Transient
    public void setPlainProxyPassword(String password) {
        this.PROXY_PASSWORD_CRYPT = this.encode(password);
    }

    private String encode(String password) {
        return new String(new Base64().encode(password.getBytes()));
    }

    public PasswordAuthentication getGenericPromptedAuthentication(final String prefix, final String host, final String prompt, final int port, final boolean remember) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return (PasswordAuthentication)this.myTestGenericAuthRunnable.get();
        }
        final PasswordAuthentication[] value = new PasswordAuthentication[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (HttpConfigurable.this.isGenericPasswordCanceled(host, port)) {
                    return;
                }
                PasswordAuthentication password = HttpConfigurable.this.getGenericPassword(host, port);
                if (password != null) {
                    value[0] = password;
                    return;
                }
                AuthenticationDialog dlg = new AuthenticationDialog(PopupUtil.getActiveComponent(), prefix + host, "Please enter credentials for: " + prompt, "", "", remember);
                dlg.show();
                if (dlg.getExitCode() == 0) {
                    AuthenticationPanel panel = dlg.getPanel();
                    boolean remember1 = remember && panel.isRememberPassword();
                    value[0] = new PasswordAuthentication(panel.getLogin(), panel.getPassword());
                    HttpConfigurable.this.putGenericPassword(host, port, value[0], remember1);
                } else {
                    HttpConfigurable.this.setGenericPasswordCanceled(host, port);
                }
            }
        };
        this.runAboveAll(runnable);
        return value[0];
    }

    public PasswordAuthentication getPromptedAuthentication(final String host, final String prompt) {
        if (this.AUTHENTICATION_CANCELLED) {
            return null;
        }
        String password = this.getPlainProxyPassword();
        if (this.PROXY_AUTHENTICATION && !StringUtil.isEmptyOrSpaces((String)this.PROXY_LOGIN) && !StringUtil.isEmptyOrSpaces((String)password)) {
            return new PasswordAuthentication(this.PROXY_LOGIN, password.toCharArray());
        }
        if (ApplicationManager.getApplication() == null || ApplicationManager.getApplication().isDisposeInProgress() || ApplicationManager.getApplication().isDisposed()) {
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return (PasswordAuthentication)this.myTestGenericAuthRunnable.get();
        }
        final String login = this.PROXY_LOGIN == null ? "" : this.PROXY_LOGIN;
        final PasswordAuthentication[] value = new PasswordAuthentication[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (HttpConfigurable.this.AUTHENTICATION_CANCELLED) {
                    return;
                }
                String password = HttpConfigurable.this.getPlainProxyPassword();
                if (HttpConfigurable.this.PROXY_AUTHENTICATION && !StringUtil.isEmptyOrSpaces((String)HttpConfigurable.this.PROXY_LOGIN) && !StringUtil.isEmptyOrSpaces((String)password)) {
                    value[0] = new PasswordAuthentication(HttpConfigurable.this.PROXY_LOGIN, password.toCharArray());
                    return;
                }
                AuthenticationDialog dlg = new AuthenticationDialog(PopupUtil.getActiveComponent(), "Proxy authentication: " + host, "Please enter credentials for: " + prompt, login, "", HttpConfigurable.this.KEEP_PROXY_PASSWORD);
                dlg.show();
                if (dlg.getExitCode() == 0) {
                    HttpConfigurable.this.PROXY_AUTHENTICATION = true;
                    AuthenticationPanel panel = dlg.getPanel();
                    HttpConfigurable.this.KEEP_PROXY_PASSWORD = panel.isRememberPassword();
                    HttpConfigurable.this.PROXY_LOGIN = panel.getLogin();
                    HttpConfigurable.this.setPlainProxyPassword(String.valueOf(panel.getPassword()));
                    value[0] = new PasswordAuthentication(panel.getLogin(), panel.getPassword());
                } else {
                    HttpConfigurable.this.AUTHENTICATION_CANCELLED = true;
                }
            }
        };
        this.runAboveAll(runnable);
        return value[0];
    }

    private void runAboveAll(final Runnable runnable) {
        Runnable throughSwing = new Runnable(){

            @Override
            public void run() {
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                    return;
                }
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (InterruptedException e) {
                    LOG.info((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    LOG.info((Throwable)e);
                }
            }
        };
        if (ProgressManager.getInstance().getProgressIndicator() != null) {
            if (ProgressManager.getInstance().getProgressIndicator().isModal()) {
                WaitForProgressToShow.runOrInvokeAndWaitAboveProgress(runnable);
            } else {
                throughSwing.run();
            }
        } else {
            throughSwing.run();
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.loadState((HttpConfigurable)XmlSerializer.deserialize((Element)element, HttpConfigurable.class));
    }

    public void writeExternal(Element element) throws WriteExternalException {
        CommonProxy.isInstalledAssertion();
        XmlSerializer.serializeInto((Object)this.getState(), (Element)element);
        if (this.USE_PROXY_PAC && this.USE_HTTP_PROXY && !ApplicationManager.getApplication().isDisposed()) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdeFrame frame = IdeFocusManager.findInstance().getLastFocusedFrame();
                    if (frame != null) {
                        HttpConfigurable.this.USE_PROXY_PAC = false;
                        Messages.showMessageDialog(frame.getComponent(), "Proxy: both 'use proxy' and 'autodetect proxy' settings were set.\nOnly one of these options should be selected.\nPlease re-configure.", "Proxy setup", Messages.getWarningIcon());
                        HttpConfigurable.editConfigurable(frame.getComponent());
                    }
                }
            }, ModalityState.NON_MODAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareURL(String url) throws IOException {
        CommonProxy.isInstalledAssertion();
        URLConnection connection = this.openConnection(url);
        try {
            connection.setConnectTimeout(3000);
            connection.setReadTimeout(3000);
            connection.connect();
            connection.getInputStream();
        }
        catch (Throwable e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
        }
        finally {
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).disconnect();
            }
        }
    }

    public URLConnection openConnection(@NotNull String location) throws IOException {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/net/HttpConfigurable", "openConnection"));
        }
        CommonProxy.isInstalledAssertion();
        URL url = new URL(location);
        URLConnection urlConnection = null;
        List<Proxy> proxies = CommonProxy.getInstance().select(url);
        if (proxies == null || proxies.isEmpty()) {
            urlConnection = url.openConnection();
        } else {
            IOException ioe = null;
            for (Proxy proxy : proxies) {
                try {
                    urlConnection = url.openConnection(proxy);
                }
                catch (IOException e) {
                    ioe = e;
                }
            }
            if (urlConnection == null && ioe != null) {
                throw ioe;
            }
        }
        return urlConnection;
    }

    @NotNull
    public HttpURLConnection openHttpConnection(@NotNull String location) throws IOException {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/net/HttpConfigurable", "openHttpConnection"));
        }
        URLConnection urlConnection = this.openConnection(location);
        if (urlConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
            if (httpURLConnection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/HttpConfigurable", "openHttpConnection"));
            }
            return httpURLConnection;
        }
        throw new IOException("Expected " + HttpURLConnection.class + ", but got " + urlConnection.getClass());
    }

    public static List<KeyValue<String, String>> getJvmPropertiesList(boolean withAutodetection, @Nullable URI uri) {
        ArrayList<KeyValue<String, String>> result;
        block7: {
            List<Proxy> proxies;
            HttpConfigurable me;
            block5: {
                boolean putCredentials;
                block6: {
                    me = HttpConfigurable.getInstance();
                    if (!me.USE_HTTP_PROXY && !me.USE_PROXY_PAC) {
                        return Collections.emptyList();
                    }
                    result = new ArrayList<KeyValue<String, String>>();
                    if (!me.USE_HTTP_PROXY) break block5;
                    boolean bl = putCredentials = me.KEEP_PROXY_PASSWORD && StringUtil.isNotEmpty((String)me.PROXY_LOGIN);
                    if (!me.PROXY_TYPE_IS_SOCKS) break block6;
                    result.add((KeyValue<String, String>)KeyValue.create((Object)"socksProxyHost", (Object)me.PROXY_HOST));
                    result.add((KeyValue<String, String>)KeyValue.create((Object)"socksProxyPort", (Object)String.valueOf(me.PROXY_PORT)));
                    if (putCredentials) {
                        result.add((KeyValue<String, String>)KeyValue.create((Object)"java.net.socks.username", (Object)me.PROXY_LOGIN));
                        result.add((KeyValue<String, String>)KeyValue.create((Object)"java.net.socks.password", (Object)me.getPlainProxyPassword()));
                    }
                    break block7;
                }
                result.add((KeyValue<String, String>)KeyValue.create((Object)"http.proxyHost", (Object)me.PROXY_HOST));
                result.add((KeyValue<String, String>)KeyValue.create((Object)"http.proxyPort", (Object)String.valueOf(me.PROXY_PORT)));
                result.add((KeyValue<String, String>)KeyValue.create((Object)"https.proxyHost", (Object)me.PROXY_HOST));
                result.add((KeyValue<String, String>)KeyValue.create((Object)"https.proxyPort", (Object)String.valueOf(me.PROXY_PORT)));
                if (!putCredentials) break block7;
                result.add((KeyValue<String, String>)KeyValue.create((Object)"proxy.authentication.username", (Object)me.PROXY_LOGIN));
                result.add((KeyValue<String, String>)KeyValue.create((Object)"proxy.authentication.password", (Object)me.getPlainProxyPassword()));
                break block7;
            }
            if (me.USE_PROXY_PAC && withAutodetection && uri != null && (proxies = CommonProxy.getInstance().select(uri)) != null && !proxies.isEmpty()) {
                for (Proxy proxy : proxies) {
                    SocketAddress address;
                    if (!HttpConfigurable.isRealProxy(proxy) || !((address = proxy.address()) instanceof InetSocketAddress)) continue;
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
                    if (Proxy.Type.SOCKS.equals((Object)proxy.type())) {
                        result.add((KeyValue<String, String>)KeyValue.create((Object)"socksProxyHost", (Object)inetSocketAddress.getHostName()));
                        result.add((KeyValue<String, String>)KeyValue.create((Object)"socksProxyPort", (Object)String.valueOf(inetSocketAddress.getPort())));
                        continue;
                    }
                    result.add((KeyValue<String, String>)KeyValue.create((Object)"http.proxyHost", (Object)inetSocketAddress.getHostName()));
                    result.add((KeyValue<String, String>)KeyValue.create((Object)"http.proxyPort", (Object)String.valueOf(inetSocketAddress.getPort())));
                    result.add((KeyValue<String, String>)KeyValue.create((Object)"https.proxyHost", (Object)inetSocketAddress.getHostName()));
                    result.add((KeyValue<String, String>)KeyValue.create((Object)"https.proxyPort", (Object)String.valueOf(inetSocketAddress.getPort())));
                }
            }
        }
        return result;
    }

    public static boolean isRealProxy(Proxy proxy) {
        return !Proxy.NO_PROXY.equals(proxy) && !Proxy.Type.DIRECT.equals((Object)proxy.type());
    }

    public static List<String> convertArguments(@NotNull List<KeyValue<String, String>> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/net/HttpConfigurable", "convertArguments"));
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(list.size());
        for (KeyValue<String, String> value : list) {
            result.add("-D" + (String)value.getKey() + "=" + (String)value.getValue());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearGenericPasswords() {
        Object object = this.myLock;
        synchronized (object) {
            this.myGenericPasswords.clear();
            this.myGenericCancelled.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGeneric(CommonProxy.HostInfo info) {
        Object object = this.myLock;
        synchronized (object) {
            this.myGenericPasswords.remove(info);
        }
    }

    public static class ProxyInfo {
        public boolean myStore;
        public String myUsername;
        public String myPasswordCrypt;

        public ProxyInfo() {
        }

        public ProxyInfo(boolean store, String username, String passwordCrypt) {
            this.myStore = store;
            this.myUsername = username;
            this.myPasswordCrypt = passwordCrypt;
        }

        public boolean isStore() {
            return this.myStore;
        }

        public void setStore(boolean store) {
            this.myStore = store;
        }

        public String getUsername() {
            return this.myUsername;
        }

        public void setUsername(String username) {
            this.myUsername = username;
        }

        public String getPasswordCrypt() {
            return this.myPasswordCrypt;
        }

        public void setPasswordCrypt(String passwordCrypt) {
            this.myPasswordCrypt = passwordCrypt;
        }
    }
}

