/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexableFileSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileBasedIndex
implements BaseComponent {
    public static final boolean ourEnableTracingOfKeyHashToVirtualFileMapping = SystemProperties.getBooleanProperty((String)"idea.enable.tracing.keyhash2virtualfile", (boolean)true);

    public abstract void iterateIndexableFiles(@NotNull ContentIterator var1, @NotNull Project var2, ProgressIndicator var3);

    public abstract void registerIndexableSet(@NotNull IndexableFileSet var1, @Nullable Project var2);

    public abstract void removeIndexableSet(@NotNull IndexableFileSet var1);

    public static FileBasedIndex getInstance() {
        return ApplicationManager.getApplication().getComponent(FileBasedIndex.class);
    }

    public static int getFileId(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndex", "getFileId"));
        }
        if (file instanceof VirtualFileWithId) {
            return ((VirtualFileWithId)((Object)file)).getId();
        }
        throw new IllegalArgumentException("Virtual file doesn't support id: " + file + ", implementation class: " + file.getClass().getName());
    }

    public abstract VirtualFile findFileById(Project var1, int var2);

    public void requestRebuild(ID<?, ?> indexId) {
        this.requestRebuild(indexId, new Throwable());
    }

    @Override
    @NonNls
    @NotNull
    public String getComponentName() {
        if ("FileBasedIndex" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndex", "getComponentName"));
        }
        return "FileBasedIndex";
    }

    @NotNull
    public abstract <K, V> List<V> getValues(@NotNull ID<K, V> var1, @NotNull K var2, @NotNull GlobalSearchScope var3);

    @NotNull
    public abstract <K, V> Collection<VirtualFile> getContainingFiles(@NotNull ID<K, V> var1, @NotNull K var2, @NotNull GlobalSearchScope var3);

    public abstract <K, V> boolean processValues(@NotNull ID<K, V> var1, @NotNull K var2, @Nullable VirtualFile var3, @NotNull ValueProcessor<V> var4, @NotNull GlobalSearchScope var5);

    public <K, V> boolean processValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, @NotNull ValueProcessor<V> processor, @NotNull GlobalSearchScope filter, @Nullable IdFilter idFilter) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndex", "processValues"));
        }
        if (dataKey == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndex", "processValues"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/util/indexing/FileBasedIndex", "processValues"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/util/indexing/FileBasedIndex", "processValues"));
        }
        return this.processValues(indexId, dataKey, inFile, processor, filter);
    }

    public abstract <K, V> boolean processFilesContainingAllKeys(@NotNull ID<K, V> var1, @NotNull Collection<K> var2, @NotNull GlobalSearchScope var3, @Nullable Condition<V> var4, @NotNull Processor<VirtualFile> var5);

    @NotNull
    public abstract <K> Collection<K> getAllKeys(@NotNull ID<K, ?> var1, @NotNull Project var2);

    public abstract <K> void ensureUpToDate(@NotNull ID<K, ?> var1, @Nullable Project var2, @Nullable GlobalSearchScope var3);

    public abstract void requestRebuild(ID<?, ?> var1, Throwable var2);

    public abstract <K> void scheduleRebuild(@NotNull ID<K, ?> var1, @NotNull Throwable var2);

    public abstract void requestReindex(@NotNull VirtualFile var1);

    public abstract void requestReindexExcluded(@NotNull VirtualFile var1);

    public abstract <K, V> boolean getFilesWithKey(@NotNull ID<K, V> var1, @NotNull Set<K> var2, @NotNull Processor<VirtualFile> var3, @NotNull GlobalSearchScope var4);

    public abstract <K> boolean processAllKeys(@NotNull ID<K, ?> var1, @NotNull Processor<K> var2, @Nullable Project var3);

    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<K> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndex", "processAllKeys"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndex", "processAllKeys"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/indexing/FileBasedIndex", "processAllKeys"));
        }
        return this.processAllKeys(indexId, processor, scope.getProject());
    }

    public static interface FileTypeSpecificInputFilter
    extends InputFilter {
        public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> var1);
    }

    public static interface InputFilter {
        public boolean acceptInput(@NotNull VirtualFile var1);
    }

    public static interface ValueProcessor<V> {
        public boolean process(VirtualFile var1, V var2);
    }
}

