/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtilRt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathUtil {
    private PathUtil() {
    }

    @Nullable
    public static String getLocalPath(@Nullable VirtualFile file) {
        if (file == null || !file.isValid()) {
            return null;
        }
        if (file.getFileSystem().getProtocol().equals("jar") && file.getParent() != null) {
            return null;
        }
        return PathUtil.getLocalPath(file.getPath());
    }

    @NotNull
    public static String getLocalPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/PathUtil", "getLocalPath"));
        }
        String string = FileUtil.toSystemDependentName((String)StringUtil.trimEnd((String)path, (String)"!/"));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "getLocalPath"));
        }
        return string;
    }

    @NotNull
    public static VirtualFile getLocalFile(@NotNull VirtualFile file) {
        VirtualFile localFile;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/PathUtil", "getLocalFile"));
        }
        if (!file.isValid()) {
            VirtualFile virtualFile = file;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "getLocalFile"));
            }
            return virtualFile;
        }
        if (file.getFileSystem() instanceof LocalFileProvider && (localFile = ((LocalFileProvider)((Object)file.getFileSystem())).getLocalVirtualFileFor(file)) != null) {
            VirtualFile virtualFile = localFile;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "getLocalFile"));
            }
            return virtualFile;
        }
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "getLocalFile"));
        }
        return virtualFile;
    }

    @NotNull
    public static String getJarPathForClass(@NotNull Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/PathUtil", "getJarPathForClass"));
        }
        String pathForClass = PathManager.getJarPathForClass((Class)aClass);
        assert (pathForClass != null) : aClass;
        String string = pathForClass;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "getJarPathForClass"));
        }
        return string;
    }

    @NotNull
    public static String toPresentableUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/PathUtil", "toPresentableUrl"));
        }
        String string = PathUtil.getLocalPath(VirtualFileManager.extractPath(url));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "toPresentableUrl"));
        }
        return string;
    }

    public static String getCanonicalPath(@NonNls String path) {
        return FileUtil.toCanonicalPath((String)path);
    }

    @NotNull
    public static String getFileName(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/PathUtil", "getFileName"));
        }
        String string = PathUtilRt.getFileName((String)path);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "getFileName"));
        }
        return string;
    }

    @NotNull
    public static String getParentPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/PathUtil", "getParentPath"));
        }
        String string = PathUtilRt.getParentPath((String)path);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "getParentPath"));
        }
        return string;
    }

    @NotNull
    public static String suggestFileName(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/PathUtil", "suggestFileName"));
        }
        String string = PathUtilRt.suggestFileName((String)text);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "suggestFileName"));
        }
        return string;
    }

    @NotNull
    public static String suggestFileName(@NotNull String text, boolean allowDots, boolean allowSpaces) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/PathUtil", "suggestFileName"));
        }
        String string = PathUtilRt.suggestFileName((String)text, (boolean)allowDots, (boolean)allowSpaces);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "suggestFileName"));
        }
        return string;
    }

    public static boolean isValidFileName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/PathUtil", "isValidFileName"));
        }
        return PathUtilRt.isValidFileName((String)fileName);
    }

    @Contract(value="null -> null; !null -> !null")
    public static String toSystemIndependentName(@Nullable String path) {
        return path == null ? null : FileUtilRt.toSystemIndependentName((String)path);
    }

    @Contract(value="null -> null; !null -> !null")
    public static String toSystemDependentName(@Nullable String path) {
        return path == null ? null : FileUtilRt.toSystemDependentName((String)path);
    }
}

