/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncFutureFactory;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class CollectionQuery<T>
implements Query<T> {
    private final Collection<T> myCollection;

    public CollectionQuery(@NotNull Collection<T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/CollectionQuery", "<init>"));
        }
        this.myCollection = collection;
    }

    @Override
    @NotNull
    public Collection<T> findAll() {
        Collection<T> collection = this.myCollection;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CollectionQuery", "findAll"));
        }
        return collection;
    }

    @Override
    public T findFirst() {
        Iterator<T> i = this.iterator();
        return i.hasNext() ? (T)i.next() : null;
    }

    @Override
    public boolean forEach(@NotNull Processor<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/CollectionQuery", "forEach"));
        }
        return ContainerUtil.process(this.myCollection, consumer);
    }

    @Override
    @NotNull
    public AsyncFuture<Boolean> forEachAsync(@NotNull Processor<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/CollectionQuery", "forEachAsync"));
        }
        AsyncFutureResult<Boolean> result = AsyncFutureFactory.getInstance().createAsyncFutureResult();
        try {
            result.set(this.forEach(consumer));
        }
        catch (Throwable t) {
            result.setException(t);
        }
        AsyncFutureResult<Boolean> asyncFutureResult = result;
        if (asyncFutureResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CollectionQuery", "forEachAsync"));
        }
        return asyncFutureResult;
    }

    @Override
    @NotNull
    public T[] toArray(@NotNull T[] a) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/CollectionQuery", "toArray"));
        }
        T[] TArray = this.findAll().toArray(a);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CollectionQuery", "toArray"));
        }
        return TArray;
    }

    @Override
    public Iterator<T> iterator() {
        return this.myCollection.iterator();
    }
}

