/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class UsageScopeGroupingRule
implements UsageGroupingRule {
    private static final UsageScopeGroup TEST = new UsageScopeGroup(0){

        @Override
        public Icon getIcon(boolean isOpen) {
            return AllIcons.Modules.TestSourceFolder;
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            if ("Test" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/UsageScopeGroupingRule$1", "getText"));
            }
            return "Test";
        }
    };
    private static final UsageScopeGroup PRODUCTION = new UsageScopeGroup(1){

        @Override
        public Icon getIcon(boolean isOpen) {
            return PlatformIcons.SOURCE_FOLDERS_ICON;
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            if ("Production" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/UsageScopeGroupingRule$2", "getText"));
            }
            return "Production";
        }
    };
    private static final UsageScopeGroup LIBRARY = new UsageScopeGroup(2){

        @Override
        public Icon getIcon(boolean isOpen) {
            return PlatformIcons.LIBRARY_ICON;
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            if ("Library" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/UsageScopeGroupingRule$3", "getText"));
            }
            return "Library";
        }
    };

    @Override
    public UsageGroup groupUsage(@NotNull Usage usage) {
        boolean isInLib;
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/rules/UsageScopeGroupingRule", "groupUsage"));
        }
        if (!(usage instanceof PsiElementUsage)) {
            return null;
        }
        PsiElementUsage elementUsage = (PsiElementUsage)usage;
        PsiElement element = elementUsage.getElement();
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile(element);
        if (virtualFile == null) {
            return null;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(element.getProject()).getFileIndex();
        boolean bl = isInLib = fileIndex.isInLibraryClasses(virtualFile) || fileIndex.isInLibrarySource(virtualFile);
        if (isInLib) {
            return LIBRARY;
        }
        boolean isInTest = fileIndex.isInTestSourceContent(virtualFile);
        return isInTest ? TEST : PRODUCTION;
    }

    private static abstract class UsageScopeGroup
    implements UsageGroup {
        private final int myCode;

        private UsageScopeGroup(int code) {
            this.myCode = code;
        }

        @Override
        public void update() {
        }

        @Override
        public FileStatus getFileStatus() {
            return null;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public void navigate(boolean focus) {
        }

        @Override
        public boolean canNavigate() {
            return false;
        }

        @Override
        public boolean canNavigateToSource() {
            return false;
        }

        @Override
        public int compareTo(@NotNull UsageGroup usageGroup) {
            if (usageGroup == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/rules/UsageScopeGroupingRule$UsageScopeGroup", "compareTo"));
            }
            return this.getText(null).compareTo(usageGroup.getText(null));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UsageScopeGroup)) {
                return false;
            }
            UsageScopeGroup usageTypeGroup = (UsageScopeGroup)o;
            return this.myCode == usageTypeGroup.myCode;
        }

        public int hashCode() {
            return this.myCode;
        }
    }
}

