/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.usages.UsageView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;

public abstract class Node
extends DefaultMutableTreeNode {
    protected final DefaultTreeModel myTreeModel;
    private String myCachedText;
    private byte myCachedFlags;
    private static final int INVALID_FLAG = 0;
    private static final int READ_ONLY_FLAG = 1;
    private static final int READ_ONLY_COMPUTED_FLAG = 2;
    private static final int EXCLUDED_FLAG = 3;
    private static final int UPDATED_FLAG = 4;

    private boolean isFlagSet(@FlagConstant int flag) {
        int state = this.myCachedFlags >> flag;
        return (state & 1) != 0;
    }

    private void setFlag(@FlagConstant int flag, boolean value) {
        int state = value ? 1 : 0;
        this.myCachedFlags = (byte)(this.myCachedFlags & ~(1 << flag) | state << flag);
    }

    protected Node(@NotNull DefaultTreeModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/Node", "<init>"));
        }
        this.myTreeModel = model;
    }

    public abstract String tree2string(int var1, String var2);

    protected abstract boolean isDataValid();

    protected abstract boolean isDataReadOnly();

    protected abstract boolean isDataExcluded();

    protected abstract String getText(@NotNull UsageView var1);

    public final boolean isValid() {
        return !this.isFlagSet(0);
    }

    public final boolean isReadOnly() {
        boolean result;
        boolean computed = this.isFlagSet(2);
        if (computed) {
            result = this.isFlagSet(1);
        } else {
            result = this.isDataReadOnly();
            this.setFlag(2, true);
            this.setFlag(1, result);
        }
        return result;
    }

    public final boolean isExcluded() {
        return this.isFlagSet(3);
    }

    public final void update(@NotNull UsageView view) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/impl/Node", "update"));
        }
        boolean isDataValid = this.isDataValid();
        boolean isReadOnly = this.isDataReadOnly();
        boolean isExcluded = this.isDataExcluded();
        String text = this.getText(view);
        boolean cachedValid = this.isValid();
        boolean cachedReadOnly = this.isFlagSet(1);
        boolean cachedExcluded = this.isFlagSet(3);
        if (isDataValid != cachedValid || isReadOnly != cachedReadOnly || isExcluded != cachedExcluded || !Comparing.equal((String)this.myCachedText, (String)text)) {
            this.setFlag(0, !isDataValid);
            this.setFlag(1, isReadOnly);
            this.setFlag(3, isExcluded);
            this.myCachedText = text;
            this.updateNotify();
            this.myTreeModel.nodeChanged(this);
        }
        this.setFlag(4, true);
    }

    public void markNeedUpdate() {
        this.setFlag(4, false);
    }

    public boolean needsUpdate() {
        return !this.isFlagSet(4);
    }

    protected void updateNotify() {
    }

    static @interface FlagConstant {
    }
}

