/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UsageModelTracker
implements Disposable {
    private final List<UsageModelTrackerListener> myListeners;

    public UsageModelTracker(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/UsageModelTracker", "<init>"));
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        PsiTreeChangeAdapter myPsiListener = new PsiTreeChangeAdapter(){

            @Override
            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/UsageModelTracker$1", "childAdded"));
                }
                UsageModelTracker.this.doFire(event, false);
            }

            @Override
            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/UsageModelTracker$1", "childRemoved"));
                }
                UsageModelTracker.this.doFire(event, false);
            }

            @Override
            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/UsageModelTracker$1", "childReplaced"));
                }
                UsageModelTracker.this.doFire(event, false);
            }

            @Override
            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/UsageModelTracker$1", "childrenChanged"));
                }
                UsageModelTracker.this.doFire(event, false);
            }

            @Override
            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/UsageModelTracker$1", "childMoved"));
                }
                UsageModelTracker.this.doFire(event, false);
            }

            @Override
            public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/UsageModelTracker$1", "propertyChanged"));
                }
                UsageModelTracker.this.doFire(event, true);
            }
        };
        PsiManager.getInstance(project).addPsiTreeChangeListener(myPsiListener, this);
    }

    private void doFire(@NotNull PsiTreeChangeEvent event, boolean propertyChange) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/UsageModelTracker", "doFire"));
        }
        if (!(event.getFile() instanceof PsiCodeFragment)) {
            for (UsageModelTrackerListener listener : this.myListeners) {
                listener.modelChanged(propertyChange);
            }
        }
    }

    public void dispose() {
    }

    public void addListener(@NotNull UsageModelTrackerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/UsageModelTracker", "addListener"));
        }
        this.myListeners.add(listener);
    }

    public void removeListener(@NotNull UsageModelTrackerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/UsageModelTracker", "removeListener"));
        }
        this.myListeners.remove(listener);
    }

    public static interface UsageModelTrackerListener {
        public void modelChanged(boolean var1);
    }
}

