/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.openapi.editor.markup.AttributesFlyweight;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;

public class TextChunk {
    public static final TextChunk[] EMPTY_ARRAY = new TextChunk[0];
    private final AttributesFlyweight myAttributes;
    private final String myText;

    public TextChunk(@NotNull TextAttributes attributes, @NotNull String text) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usages/TextChunk", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/usages/TextChunk", "<init>"));
        }
        this.myAttributes = attributes.getFlyweight();
        this.myText = text;
    }

    @NotNull
    public TextAttributes getAttributes() {
        TextAttributes textAttributes = TextAttributes.fromFlyweight(this.myAttributes);
        if (textAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/TextChunk", "getAttributes"));
        }
        return textAttributes;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/TextChunk", "getText"));
        }
        return string;
    }

    public String toString() {
        return this.getText();
    }

    @NotNull
    public SimpleTextAttributes getSimpleAttributesIgnoreBackground() {
        SimpleTextAttributes simples = SimpleTextAttributes.fromTextAttributes(this.getAttributes());
        SimpleTextAttributes simpleTextAttributes = simples = new SimpleTextAttributes(null, simples.getFgColor(), simples.getWaveColor(), simples.getStyle());
        if (simpleTextAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/TextChunk", "getSimpleAttributesIgnoreBackground"));
        }
        return simpleTextAttributes;
    }
}

