/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.switcher;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.switcher.SwitchManager;
import com.intellij.ui.switcher.SwitchProvider;
import com.intellij.ui.switcher.SwitchTarget;
import com.intellij.util.Alarm;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeMap;
import org.jetbrains.annotations.Nullable;

public class SwitchingSession
implements KeyEventDispatcher,
Disposable {
    private SwitchProvider myProvider;
    private KeyEvent myInitialEvent;
    private boolean myFinished;
    private LinkedHashSet<SwitchTarget> myTargets = new LinkedHashSet();
    private IdeGlassPane myGlassPane;
    private Component myRootComponent;
    private SwitchTarget mySelection;
    private SwitchTarget myStartSelection;
    private boolean mySelectionWasMoved;
    private Alarm myAlarm = new Alarm();
    private Runnable myAutoApplyRunnable = new Runnable(){

        @Override
        public void run() {
            if (SwitchingSession.this.myManager.canApplySwitch()) {
                SwitchingSession.this.myManager.applySwitch();
            }
        }
    };
    private SwitchManager myManager;
    private Spotlight mySpotlight;
    private boolean myShowspots;
    private Alarm myShowspotsAlarm;
    private Runnable myShowspotsRunnable = new Runnable(){

        @Override
        public void run() {
            if (!SwitchingSession.this.myShowspots) {
                SwitchingSession.this.setShowspots(true);
            }
        }
    };
    private boolean myFadingAway;
    private Disposable myPainterDisposable = Disposer.newDisposable();

    public SwitchingSession(SwitchManager mgr, SwitchProvider provider, KeyEvent e, @Nullable SwitchTarget preselected, boolean showSpots) {
        this.myManager = mgr;
        this.myProvider = provider;
        this.myInitialEvent = e;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        this.myTargets.addAll(this.myProvider.getTargets(true, true));
        Container eachParent = this.myProvider.getComponent();
        for (eachParent = eachParent.getParent(); eachParent != null; eachParent = eachParent.getParent()) {
            if (!(eachParent instanceof SwitchProvider)) continue;
            SwitchProvider eachProvider = (SwitchProvider)((Object)eachParent);
            this.myTargets.addAll(eachProvider.getTargets(true, false));
            if (eachProvider.isCycleRoot()) break;
        }
        if (this.myTargets.size() == 0) {
            Disposer.dispose((Disposable)this);
            return;
        }
        this.mySelection = this.myProvider.getCurrentTarget();
        if (this.myTargets.contains(preselected)) {
            this.mySelection = preselected;
        }
        this.myStartSelection = this.mySelection;
        this.myGlassPane = IdeGlassPaneUtil.find(this.myProvider.getComponent());
        this.myRootComponent = this.myProvider.getComponent().getRootPane();
        this.mySpotlight = new Spotlight(this.myRootComponent);
        this.myGlassPane.addPainter(this.myRootComponent, this.mySpotlight, this.myPainterDisposable);
        this.myShowspotsAlarm = new Alarm(this);
        this.restartShowspotsAlarm();
        this.myShowspots = showSpots;
        this.mySpotlight.setNeedsRepaint(true);
    }

    public void setFadeaway(boolean fadeAway) {
        this.myFadingAway = fadeAway;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (this.myFadingAway) {
            this._dispose();
        } else {
            KeyEvent event = this.myInitialEvent;
            if (event == null || (e.getModifiers() & event.getModifiers()) == 0) {
                this.finish(!this.isSelectionWasMoved());
                return false;
            }
        }
        return false;
    }

    private SwitchTarget getSelection() {
        return this.mySelection;
    }

    public boolean isSelectionWasMoved() {
        return this.mySelectionWasMoved;
    }

    public void up() {
        this.setSelection(this.getNextTarget(Direction.up));
    }

    public void down() {
        this.setSelection(this.getNextTarget(Direction.down));
    }

    public void left() {
        this.setSelection(this.getNextTarget(Direction.left));
    }

    public void right() {
        this.setSelection(this.getNextTarget(Direction.right));
    }

    private void setSelection(SwitchTarget target) {
        if (target == null) {
            return;
        }
        this.mySelection = target;
        this.mySelectionWasMoved |= !this.mySelection.equals(this.myStartSelection);
        this.mySpotlight.setNeedsRepaint(true);
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(this.myAutoApplyRunnable, Registry.intValue((String)"actionSystem.autoSelectTimeout"));
        this.restartShowspotsAlarm();
    }

    private SwitchTarget getNextTarget(Direction direction) {
        Integer[] distancesArray;
        Point eachPoint;
        if (this.myTargets.size() == 1) {
            return this.getSelection();
        }
        ArrayList<Point> points = new ArrayList<Point>();
        Point selected = null;
        HashMap<SwitchTarget, Point> target2Point = new HashMap<SwitchTarget, Point>();
        for (SwitchTarget each : this.myTargets) {
            Rectangle eachRec = each.getRectangle().getRectangleOn(this.myRootComponent);
            eachPoint = null;
            switch (direction) {
                case up: {
                    eachPoint = new Point(eachRec.x + eachRec.width / 2, eachRec.y + eachRec.height);
                    break;
                }
                case down: {
                    eachPoint = new Point(eachRec.x + eachRec.width / 2, eachRec.y);
                    break;
                }
                case left: {
                    eachPoint = new Point(eachRec.x + eachRec.width, eachRec.y + eachRec.height / 2);
                    break;
                }
                case right: {
                    eachPoint = new Point(eachRec.x, eachRec.y + eachRec.height / 2);
                }
            }
            if (each.equals(this.mySelection)) {
                switch (direction) {
                    case up: {
                        selected = new Point(eachRec.x + eachRec.width / 2, eachRec.y);
                        break;
                    }
                    case down: {
                        selected = new Point(eachRec.x + eachRec.width / 2, eachRec.y + eachRec.height);
                        break;
                    }
                    case left: {
                        selected = new Point(eachRec.x, eachRec.y + eachRec.height / 2);
                        break;
                    }
                    case right: {
                        selected = new Point(eachRec.x + eachRec.width, eachRec.y + eachRec.height / 2);
                    }
                }
                points.add(selected);
                target2Point.put(each, selected);
                continue;
            }
            points.add(eachPoint);
            target2Point.put(each, eachPoint);
        }
        TreeMap<Integer, SwitchTarget> distance = new TreeMap<Integer, SwitchTarget>();
        for (SwitchTarget eachTarget : this.myTargets) {
            eachPoint = (Point)target2Point.get(eachTarget);
            if (selected == eachPoint) continue;
            double eachDistance = Math.sqrt(Math.abs(eachPoint.getX() - selected.getX())) + Math.sqrt(Math.abs(eachPoint.getY() - selected.getY()));
            distance.put((int)eachDistance, eachTarget);
        }
        block26: for (Integer eachDistance : distancesArray = distance.keySet().toArray(new Integer[distance.size()])) {
            SwitchTarget eachTarget = (SwitchTarget)distance.get(eachDistance);
            Point eachPoint2 = (Point)target2Point.get(eachTarget);
            switch (direction) {
                case up: {
                    if (eachPoint2.y > selected.y) continue block26;
                    return eachTarget;
                }
                case down: {
                    if (eachPoint2.y < selected.y) continue block26;
                    return eachTarget;
                }
                case left: {
                    if (eachPoint2.x > selected.x) continue block26;
                    return eachTarget;
                }
                case right: {
                    if (eachPoint2.x < selected.x) continue block26;
                    return eachTarget;
                }
            }
        }
        block27: for (int i = distancesArray.length - 1; i >= 0; --i) {
            SwitchTarget eachTarget = (SwitchTarget)distance.get(distancesArray[i]);
            Point eachPoint3 = (Point)target2Point.get(eachTarget);
            switch (direction) {
                case up: {
                    if (eachPoint3.y < selected.y) continue block27;
                    return eachTarget;
                }
                case down: {
                    if (eachPoint3.y > selected.y) continue block27;
                    return eachTarget;
                }
                case left: {
                    if (eachPoint3.x < selected.x) continue block27;
                    return eachTarget;
                }
                case right: {
                    if (eachPoint3.x > selected.x) continue block27;
                    return eachTarget;
                }
            }
        }
        if (this.myTargets.size() == 0) {
            return null;
        }
        List<SwitchTarget> all = Arrays.asList(this.myTargets.toArray(new SwitchTarget[this.myTargets.size()]));
        int index = all.indexOf(this.getSelection());
        if (index + 1 < this.myTargets.size()) {
            return all.get(index + 1);
        }
        return all.get(0);
    }

    public void dispose() {
        this.myFinished = true;
        if (this.myFadingAway) {
            this.myManager.addFadingAway(this);
            this.myAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    SwitchingSession.this._dispose();
                }
            }, Registry.intValue((String)"actionSystem.keyGestureDblClickTime"));
        } else {
            this._dispose();
        }
    }

    private void _dispose() {
        this.myFadingAway = false;
        this.myManager.removeFadingAway(this);
        Disposer.dispose((Disposable)this.myPainterDisposable);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
    }

    public AsyncResult<SwitchTarget> finish(final boolean fadeAway) {
        this.myAlarm.cancelAllRequests();
        final AsyncResult<SwitchTarget> result = new AsyncResult<SwitchTarget>();
        final SwitchTarget selection = this.getSelection();
        if (selection != null) {
            selection.switchTo(true).doWhenDone(new Runnable(){

                @Override
                public void run() {
                    SwitchingSession.this.myManager.disposeCurrentSession(fadeAway);
                    result.setDone(selection);
                }
            }).notifyWhenRejected(result);
        } else {
            Disposer.dispose((Disposable)this);
            result.setDone();
        }
        return result;
    }

    public boolean isFinished() {
        return this.myFinished;
    }

    public void setShowspots(boolean showspots) {
        if (this.myShowspots != showspots) {
            this.myShowspots = showspots;
            this.mySpotlight.setNeedsRepaint(true);
        }
    }

    public boolean isShowspots() {
        return this.myShowspots;
    }

    private void restartShowspotsAlarm() {
        this.myShowspotsAlarm.cancelAllRequests();
        this.myShowspotsAlarm.addRequest(this.myShowspotsRunnable, Registry.intValue((String)"actionSystem.quickAccessShowSpotsTime"));
    }

    private static enum Direction {
        up,
        down,
        left,
        right;

    }

    private class Spotlight
    extends AbstractPainter {
        private Component myRoot;
        private Area myArea;
        private BufferedImage myBackground;

        private Spotlight(Component root) {
            this.myRoot = root;
        }

        @Override
        public boolean needsRepaint() {
            return true;
        }

        @Override
        public void executePaint(Component component, Graphics2D g) {
            int inset = -1;
            int selectedInset = -8;
            HashSet<Area> shapes = new HashSet<Area>();
            Area selected = null;
            boolean hasIntersections = false;
            Rectangle clip = g.getClipBounds();
            this.myArea = new Area(clip);
            for (SwitchTarget each : SwitchingSession.this.myTargets) {
                RelativeRectangle eachSimpleRec = each.getRectangle();
                if (eachSimpleRec == null) continue;
                boolean isSelected = each.equals(SwitchingSession.this.mySelection);
                Rectangle eachBaseRec = eachSimpleRec.getRectangleOn(this.myRoot);
                Rectangle eachShape = isSelected ? new Rectangle(eachBaseRec.x + selectedInset, eachBaseRec.y + selectedInset, eachBaseRec.width - selectedInset - selectedInset, eachBaseRec.height - selectedInset - selectedInset) : new Rectangle(eachBaseRec.x + inset, eachBaseRec.y + inset, eachBaseRec.width - inset - inset, eachBaseRec.height - inset - inset);
                if (!hasIntersections) {
                    hasIntersections = clip.contains(eachShape) || clip.intersects(eachShape);
                }
                Area eachArea = new Area(new RoundRectangle2D.Double(eachShape.x, eachShape.y, eachShape.width, eachShape.height, 6.0, 6.0));
                shapes.add(eachArea);
                if (!isSelected) continue;
                selected = eachArea;
            }
            Color fillColor = new Color(0.0f, 0.0f, 0.0f, 0.25f);
            if (!hasIntersections && SwitchingSession.this.myShowspots) {
                g.setColor(fillColor);
                g.fillRect(clip.x, clip.y, clip.width, clip.height);
                return;
            }
            for (Area each : shapes) {
                this.myArea.subtract(each);
                if (each == selected) continue;
                each.subtract(selected);
            }
            GraphicsConfig cfg = new GraphicsConfig((Graphics)g);
            cfg.setAntialiasing(true);
            if (SwitchingSession.this.myShowspots) {
                g.setColor(fillColor);
                g.fill(this.myArea);
                g.setColor(Color.lightGray);
                for (Area each : shapes) {
                    if (each == selected) continue;
                    g.draw(each);
                }
            }
            if (selected != null) {
                Color bg = Color.darkGray;
                g.setColor(ColorUtil.toAlpha((Color)bg, (int)180));
                g.setStroke(new BasicStroke(3.0f));
                g.draw(selected);
            }
            cfg.restore();
        }
    }
}

