/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpeedSearchSupply {
    private static final Key SPEED_SEARCH_COMPONENT_MARKER = new Key("SPEED_SEARCH_COMPONENT_MARKER");
    public static final DataKey<String> SPEED_SEARCH_CURRENT_QUERY = DataKey.create("SPEED_SEARCH_CURRENT_QUERY");

    @Nullable
    public static SpeedSearchSupply getSupply(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/speedSearch/SpeedSearchSupply", "getSupply"));
        }
        return SpeedSearchSupply.getSupply(component, false);
    }

    @Nullable
    public static SpeedSearchSupply getSupply(@NotNull JComponent component, boolean evenIfInactive) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/speedSearch/SpeedSearchSupply", "getSupply"));
        }
        SpeedSearchSupply speedSearch = (SpeedSearchSupply)component.getClientProperty(SPEED_SEARCH_COMPONENT_MARKER);
        if (evenIfInactive) {
            return speedSearch;
        }
        return speedSearch != null && speedSearch.isPopupActive() ? speedSearch : null;
    }

    @Nullable
    public abstract Iterable<TextRange> matchingFragments(@NotNull String var1);

    public abstract void refreshSelection();

    public abstract boolean isPopupActive();

    @Nullable
    public String getEnteredPrefix() {
        return null;
    }

    protected void installSupplyTo(final JComponent component) {
        component.putClientProperty(SPEED_SEARCH_COMPONENT_MARKER, this);
        this.addChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                component.repaint();
            }
        });
    }

    public abstract void addChangeListener(@NotNull PropertyChangeListener var1);

    public abstract void removeChangeListener(@NotNull PropertyChangeListener var1);
}

