/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.StatusText;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class JBTextField
extends JTextField
implements ComponentWithEmptyText {
    private StatusText myEmptyText;

    public JBTextField() {
        this.init();
    }

    public JBTextField(int i) {
        super(i);
        this.init();
    }

    public JBTextField(String s) {
        super(s);
        this.init();
    }

    public JBTextField(String s, int i) {
        super(s, i);
        this.init();
    }

    private void init() {
        this.myEmptyText = new StatusText(this){

            @Override
            protected boolean isStatusVisible() {
                return JBTextField.this.getText().isEmpty() && !JBTextField.this.isFocusOwner();
            }

            @Override
            protected Rectangle getTextComponentBound() {
                Rectangle b = JBTextField.this.getBounds();
                return new Rectangle(JBTextField.this.getInsets().left >> 1, 0, b.width, b.height);
            }
        };
        this.myEmptyText.clear();
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JBTextField.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                JBTextField.this.repaint();
            }
        });
    }

    @Override
    @NotNull
    public StatusText getEmptyText() {
        StatusText statusText = this.myEmptyText;
        if (statusText == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/components/JBTextField", "getEmptyText"));
        }
        return statusText;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.myEmptyText.getComponent().setFont(this.getFont());
        this.myEmptyText.paint(this, g);
    }
}

