/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBViewport;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class JBScrollPane
extends JScrollPane {
    private int myViewportBorderWidth = -1;

    public JBScrollPane(int viewportWidth) {
        this.myViewportBorderWidth = viewportWidth;
        this.updateViewportBorder();
    }

    public JBScrollPane() {
        this.setupCorners();
    }

    public JBScrollPane(Component view) {
        super(view);
        this.setupCorners();
    }

    public JBScrollPane(int vsbPolicy, int hsbPolicy) {
        super(vsbPolicy, hsbPolicy);
        this.setupCorners();
    }

    public JBScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        super(view, vsbPolicy, hsbPolicy);
        this.setupCorners();
    }

    public void setupCorners() {
        this.setBorder(IdeBorderFactory.createBorder());
        this.setCorner("UPPER_RIGHT_CORNER", new Corner("UPPER_RIGHT_CORNER"));
        this.setCorner("UPPER_LEFT_CORNER", new Corner("UPPER_LEFT_CORNER"));
        this.setCorner("LOWER_RIGHT_CORNER", new Corner("LOWER_RIGHT_CORNER"));
        this.setCorner("LOWER_LEFT_CORNER", new Corner("LOWER_LEFT_CORNER"));
    }

    @Override
    public void setUI(ScrollPaneUI ui) {
        super.setUI(ui);
        this.updateViewportBorder();
    }

    private void updateViewportBorder() {
        this.setViewportBorder(new ViewportBorder(this.myViewportBorderWidth >= 0 ? this.myViewportBorderWidth : 1));
    }

    public static ViewportBorder createIndentBorder() {
        return new ViewportBorder(2);
    }

    @Override
    public JScrollBar createVerticalScrollBar() {
        return new MyScrollBar(1);
    }

    @Override
    public JScrollBar createHorizontalScrollBar() {
        return new MyScrollBar(0);
    }

    @Override
    protected JViewport createViewport() {
        return new JBViewport();
    }

    public static boolean canBePreprocessed(MouseEvent e, JScrollBar bar) {
        ScrollBarUI ui;
        if ((e.getID() == 503 || e.getID() == 501) && (ui = bar.getUI()) instanceof BasicScrollBarUI) {
            BasicScrollBarUI bui = (BasicScrollBarUI)ui;
            try {
                Method m = BasicScrollBarUI.class.getDeclaredMethod("getThumbBounds", ArrayUtil.EMPTY_CLASS_ARRAY);
                m.setAccessible(true);
                Rectangle rect = (Rectangle)m.invoke((Object)bui, new Object[0]);
                Point point = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), bar);
                return !rect.contains(point);
            }
            catch (Exception e1) {
                return true;
            }
        }
        return true;
    }

    private static class ViewportBorder
    extends LineBorder {
        public ViewportBorder(int thickness) {
            super(null, thickness);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.updateColor(c);
            super.paintBorder(c, g, x, y, width, height);
        }

        private void updateColor(Component c) {
            if (!(c instanceof JScrollPane)) {
                return;
            }
            JViewport vp = ((JScrollPane)c).getViewport();
            if (vp == null) {
                return;
            }
            Component view = vp.getView();
            if (view == null) {
                return;
            }
            this.lineColor = view.getBackground();
        }
    }

    private static class Corner
    extends JPanel {
        private final String myPos;

        public Corner(String pos) {
            this.myPos = pos;
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor((Color)ButtonlessScrollBarUI.getTrackBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor((Color)ButtonlessScrollBarUI.getTrackBorderColor());
            int x2 = this.getWidth() - 1;
            int y2 = this.getHeight() - 1;
            if (this.myPos == "UPPER_LEFT_CORNER" || this.myPos == "UPPER_RIGHT_CORNER") {
                g.drawLine(0, y2, x2, y2);
            }
            if (this.myPos == "LOWER_LEFT_CORNER" || this.myPos == "LOWER_RIGHT_CORNER") {
                g.drawLine(0, 0, x2, 0);
            }
            if (this.myPos == "UPPER_LEFT_CORNER" || this.myPos == "LOWER_LEFT_CORNER") {
                g.drawLine(x2, 0, x2, y2);
            }
            if (this.myPos == "UPPER_RIGHT_CORNER" || this.myPos == "LOWER_RIGHT_CORNER") {
                g.drawLine(0, 0, 0, y2);
            }
        }
    }

    private class MyScrollBar
    extends JScrollPane.ScrollBar
    implements IdeGlassPane.TopComponent {
        public MyScrollBar(int orientation) {
            super(JBScrollPane.this, orientation);
        }

        @Override
        public void updateUI() {
            this.setUI(ButtonlessScrollBarUI.createNormal());
        }

        @Override
        public boolean canBePreprocessed(MouseEvent e) {
            return JBScrollPane.canBePreprocessed(e, this);
        }
    }
}

