/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.components.JBLoadingPanelListener;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBLoadingPanel
extends JPanel {
    private final JPanel myPanel;
    final LoadingDecorator myDecorator;
    private final Collection<JBLoadingPanelListener> myListeners;

    public JBLoadingPanel(@Nullable LayoutManager manager, @NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ui/components/JBLoadingPanel", "<init>"));
        }
        this(manager, parent, -1);
    }

    public JBLoadingPanel(@Nullable LayoutManager manager, @NotNull Disposable parent, int startDelayMs) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ui/components/JBLoadingPanel", "<init>"));
        }
        super(new BorderLayout());
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myPanel = manager == null ? new JPanel() : new JPanel(manager);
        this.myPanel.setOpaque(false);
        this.myDecorator = new LoadingDecorator(this.myPanel, parent, startDelayMs){

            @Override
            protected NonOpaquePanel customizeLoadingLayer(JPanel parent, JLabel text, AsyncProcessIcon icon) {
                NonOpaquePanel panel = super.customizeLoadingLayer(parent, text, icon);
                JBLoadingPanel.customizeStatusText(text);
                return panel;
            }
        };
        super.add((Component)this.myDecorator.getComponent(), "Center");
    }

    public static void customizeStatusText(JLabel text) {
        Font font = text.getFont();
        text.setFont(font.deriveFont(font.getStyle(), font.getSize() + 6));
        text.setForeground(ColorUtil.toAlpha((Color)UIUtil.getLabelForeground(), (int)150));
    }

    public void setLoadingText(String text) {
        this.myDecorator.setLoadingText(text);
    }

    public void stopLoading() {
        this.myDecorator.stopLoading();
        for (JBLoadingPanelListener listener : this.myListeners) {
            listener.onLoadingFinish();
        }
    }

    public boolean isLoading() {
        return this.myDecorator.isLoading();
    }

    public void startLoading() {
        this.myDecorator.startLoading(false);
        for (JBLoadingPanelListener listener : this.myListeners) {
            listener.onLoadingStart();
        }
    }

    public void addListener(@NotNull JBLoadingPanelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/components/JBLoadingPanel", "addListener"));
        }
        this.myListeners.add(listener);
    }

    public boolean removeListener(@NotNull JBLoadingPanelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/components/JBLoadingPanel", "removeListener"));
        }
        return this.myListeners.remove(listener);
    }

    public JPanel getContentPanel() {
        return this.myPanel;
    }

    @Override
    public Component add(Component comp) {
        return this.myPanel.add(comp);
    }

    @Override
    public Component add(Component comp, int index) {
        return this.myPanel.add(comp, index);
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.myPanel.add(comp, constraints);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getContentPanel().getPreferredSize();
    }
}

