/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.psi.PsiElement;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.PopupUpdateProcessorBase;
import java.util.Collection;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nullable;

public abstract class JBListWithHintProvider
extends JBList {
    private JBPopup myHint;

    public JBListWithHintProvider() {
        this.addSelectionListener();
    }

    public JBListWithHintProvider(ListModel dataModel) {
        super(dataModel);
        this.addSelectionListener();
    }

    public JBListWithHintProvider(Object ... listData) {
        super(listData);
        this.addSelectionListener();
    }

    public JBListWithHintProvider(Collection items) {
        super(items);
        this.addSelectionListener();
    }

    private void addSelectionListener() {
        this.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (JBListWithHintProvider.this.getClientProperty("byMouseEvent") != Boolean.TRUE) {
                    Object[] selectedValues = ((JList)e.getSource()).getSelectedValues();
                    if (selectedValues.length != 1) {
                        return;
                    }
                    PsiElement element = JBListWithHintProvider.this.getPsiElementForHint(selectedValues[0]);
                    if (element != null && element.isValid()) {
                        JBListWithHintProvider.this.updateHint(element);
                    }
                }
            }
        });
    }

    @Nullable
    protected abstract PsiElement getPsiElementForHint(Object var1);

    public void registerHint(JBPopup hint) {
        this.hideHint();
        this.myHint = hint;
    }

    public void hideHint() {
        if (this.myHint != null && this.myHint.isVisible()) {
            this.myHint.cancel();
        }
        this.myHint = null;
    }

    public void updateHint(PsiElement element) {
        if (this.myHint == null || !this.myHint.isVisible()) {
            return;
        }
        PopupUpdateProcessorBase updateProcessor = this.myHint.getUserData(PopupUpdateProcessorBase.class);
        if (updateProcessor != null) {
            updateProcessor.updatePopup(element);
        }
    }
}

