/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.HighlightableComponent;
import com.intellij.ui.HighlightedRegion;
import com.intellij.ui.HighlightedText;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.jetbrains.annotations.Nullable;

public class HyperlinkLabel
extends HighlightableComponent {
    private static final TextAttributes BOLD_ATTRIBUTES = new TextAttributes(UIUtil.getLabelTextForeground(), null, null, null, 1);
    private static final Logger LOG = Logger.getInstance((String)HyperlinkLabel.class.getName());
    private HighlightedText myHighlightedText;
    private final List<HyperlinkListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myUseIconAsLink;
    private final TextAttributes myAnchorAttributes;
    private HyperlinkListener myHyperlinkListener = null;

    public HyperlinkLabel() {
        this("");
    }

    public HyperlinkLabel(String text) {
        this(text, PlatformColors.BLUE, UIUtil.getLabelBackground(), PlatformColors.BLUE);
    }

    public HyperlinkLabel(String text, Color textForegroundColor, Color textBackgroundColor, Color textEffectColor) {
        this.myAnchorAttributes = new TextAttributes(textForegroundColor, textBackgroundColor, textEffectColor, EffectType.LINE_UNDERSCORE, 0);
        this.enforceBackgroundOutsideText(textBackgroundColor);
        this.setHyperlinkText(text);
        this.enableEvents(48L);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.adjustSize();
    }

    public void setHyperlinkText(String text) {
        this.setHyperlinkText("", text, "");
    }

    public void setHyperlinkText(String beforeLinkText, String linkText, String afterLinkText) {
        this.myUseIconAsLink = beforeLinkText.length() == 0;
        this.prepareText(beforeLinkText, linkText, afterLinkText);
        this.revalidate();
        this.adjustSize();
    }

    public void setUseIconAsLink(boolean useIconAsLink) {
        this.myUseIconAsLink = useIconAsLink;
    }

    protected void adjustSize() {
        Dimension preferredSize = this.getPreferredSize();
        this.setMinimumSize(preferredSize);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 505) {
            this.setCursor(Cursor.getDefaultCursor());
        } else if (UIUtil.isActionClick((MouseEvent)e, (int)501) && this.isOnLink(e.getX())) {
            this.fireHyperlinkEvent();
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if (e.getID() == 503) {
            this.setCursor(this.isOnLink(e.getX()) ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor());
        }
        super.processMouseMotionEvent(e);
    }

    private boolean isOnLink(int x) {
        if (this.myUseIconAsLink && this.myIcon != null && x < this.myIcon.getIconWidth()) {
            return true;
        }
        HighlightedRegion region = this.findRegionByX(x);
        return region != null && region.textAttributes == this.myAnchorAttributes;
    }

    private void prepareText(String beforeLinkText, String linkText, String afterLinkText) {
        this.setFont(UIUtil.getLabelFont());
        this.myHighlightedText = new HighlightedText();
        this.myHighlightedText.appendText(beforeLinkText, null);
        this.myHighlightedText.appendText(linkText, this.myAnchorAttributes);
        this.myHighlightedText.appendText(afterLinkText, null);
        this.myHighlightedText.applyToComponent(this);
        this.adjustSize();
    }

    @Override
    public void setText(String text) {
        this.myUseIconAsLink = false;
        super.setText(text);
    }

    public void setHyperlinkTarget(final @Nullable String url) {
        if (this.myHyperlinkListener != null) {
            this.removeHyperlinkListener(this.myHyperlinkListener);
        }
        if (url != null) {
            this.myHyperlinkListener = new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    BrowserUtil.browse(url);
                }
            };
            this.addHyperlinkListener(this.myHyperlinkListener);
        }
    }

    public void addHyperlinkListener(HyperlinkListener listener) {
        this.myListeners.add(listener);
    }

    public void removeHyperlinkListener(HyperlinkListener listener) {
        this.myListeners.remove(listener);
    }

    String getText() {
        return this.myHighlightedText.getText();
    }

    protected void fireHyperlinkEvent() {
        HyperlinkEvent e = new HyperlinkEvent(this, HyperlinkEvent.EventType.ACTIVATED, null, null);
        for (HyperlinkListener listener : this.myListeners) {
            listener.hyperlinkUpdate(e);
        }
    }

    public void doClick() {
        this.fireHyperlinkEvent();
    }

    public void setHtmlText(String text) {
        ParserDelegator parse = new ParserDelegator();
        final HighlightedText highlightedText = new HighlightedText();
        try {
            ((HTMLEditorKit.Parser)parse).parse(new StringReader(text), new HTMLEditorKit.ParserCallback(){
                private TextAttributes currentAttributes = null;

                @Override
                public void handleText(char[] data, int pos) {
                    highlightedText.appendText(new String(data), this.currentAttributes);
                }

                @Override
                public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                    if (t == HTML.Tag.B) {
                        this.currentAttributes = BOLD_ATTRIBUTES;
                    } else if (t == HTML.Tag.A) {
                        this.currentAttributes = HyperlinkLabel.this.myAnchorAttributes;
                    }
                }

                @Override
                public void handleEndTag(HTML.Tag t, int pos) {
                    this.currentAttributes = null;
                }
            }, false);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        highlightedText.applyToComponent(this);
        ((JComponent)this.getParent()).revalidate();
        this.adjustSize();
    }

    public static class Croppable
    extends HyperlinkLabel {
        @Override
        protected void adjustSize() {
        }
    }
}

