/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ExcludingTraversalPolicy
extends FocusTraversalPolicy {
    private final FocusTraversalPolicy myWrappee;
    private final Set<Component> myExcludes;
    private final Set<String> myRecursionGuard;

    public ExcludingTraversalPolicy(Component ... excludes) {
        this(KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalPolicy(), excludes);
    }

    public ExcludingTraversalPolicy(@NotNull FocusTraversalPolicy wrappee, Component ... excludes) {
        if (wrappee == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/ExcludingTraversalPolicy", "<init>"));
        }
        this.myExcludes = new THashSet();
        this.myRecursionGuard = new THashSet();
        this.myWrappee = wrappee;
        Collections.addAll(this.myExcludes, excludes);
    }

    public void exclude(Component c) {
        this.myExcludes.add(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getComponentAfter(Container aContainer, Component aComponent) {
        try {
            if (!this.myRecursionGuard.add("getComponentAfter")) {
                Component component = null;
                return component;
            }
            Component component = this.traverse(aContainer, aComponent, new Function<Pair<Container, Component>, Component>(){

                public Component fun(Pair<Container, Component> param) {
                    return ExcludingTraversalPolicy.this.myWrappee.getComponentAfter((Container)param.first, (Component)param.second);
                }
            });
            return component;
        }
        finally {
            this.myRecursionGuard.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getComponentBefore(Container aContainer, Component aComponent) {
        try {
            if (!this.myRecursionGuard.add("getComponentBefore")) {
                Component component = null;
                return component;
            }
            Component component = this.traverse(aContainer, aComponent, new Function<Pair<Container, Component>, Component>(){

                public Component fun(Pair<Container, Component> param) {
                    return ExcludingTraversalPolicy.this.myWrappee.getComponentBefore((Container)param.first, (Component)param.second);
                }
            });
            return component;
        }
        finally {
            this.myRecursionGuard.clear();
        }
    }

    private Component traverse(Container aContainer, Component aComponent, Function<Pair<Container, Component>, Component> func) {
        THashSet loopGuard = new THashSet();
        do {
            if (loopGuard.add(aComponent)) continue;
            return null;
        } while ((aComponent = (Component)func.fun((Object)Pair.create((Object)aContainer, (Object)aComponent))) != null && this.myExcludes.contains(aComponent));
        return aComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getFirstComponent(Container aContainer) {
        try {
            if (!this.myRecursionGuard.add("getFirstComponent")) {
                Component component = null;
                return component;
            }
            Component result = this.myWrappee.getFirstComponent(aContainer);
            if (result == null) {
                Component component = null;
                return component;
            }
            Component component = this.myExcludes.contains(result) ? this.getComponentAfter(aContainer, result) : result;
            return component;
        }
        finally {
            this.myRecursionGuard.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getLastComponent(Container aContainer) {
        try {
            if (!this.myRecursionGuard.add("getLastComponent")) {
                Component component = null;
                return component;
            }
            Component result = this.myWrappee.getLastComponent(aContainer);
            if (result == null) {
                Component component = null;
                return component;
            }
            Component component = this.myExcludes.contains(result) ? this.getComponentBefore(aContainer, result) : result;
            return component;
        }
        finally {
            this.myRecursionGuard.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getDefaultComponent(Container aContainer) {
        try {
            if (!this.myRecursionGuard.add("getDefaultComponent")) {
                Component component = null;
                return component;
            }
            Component component = this.getFirstComponent(aContainer);
            return component;
        }
        finally {
            this.myRecursionGuard.clear();
        }
    }
}

