/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.jetbrains.annotations.NotNull;

public class EnumComboBoxModel<E extends Enum<E>>
extends AbstractListModel
implements ComboBoxModel {
    private final List<E> myList;
    private E mySelected;

    public EnumComboBoxModel(@NotNull Class<E> en) {
        if (en == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/EnumComboBoxModel", "<init>"));
        }
        this.mySelected = null;
        this.myList = new ArrayList<E>(EnumSet.allOf(en));
        this.mySelected = (Enum)this.myList.get(0);
    }

    @Override
    public int getSize() {
        return this.myList.size();
    }

    @Override
    public E getElementAt(int index) {
        return (E)((Enum)this.myList.get(index));
    }

    @Override
    public void setSelectedItem(Object item) {
        Enum e = (Enum)item;
        this.setSelectedItem((E)e);
    }

    public void setSelectedItem(E item) {
        this.mySelected = item;
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public E getSelectedItem() {
        return this.mySelected;
    }
}

