/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorNotifications
extends AbstractProjectComponent {
    private static final ExtensionPointName<Provider> EXTENSION_POINT_NAME = new ExtensionPointName("com.intellij.editorNotificationProvider");
    private final NotNullLazyValue<Provider[]> PROVIDERS = new NotNullLazyValue<Provider[]>(){

        @NotNull
        protected Provider[] compute() {
            Provider[] providerArray = (Provider[])Extensions.getExtensions((ExtensionPointName)EXTENSION_POINT_NAME, (AreaInstance)EditorNotifications.this.myProject);
            if (providerArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorNotifications$1", "compute"));
            }
            return providerArray;
        }
    };
    private final FileEditorManager myFileEditorManager;

    public static EditorNotifications getInstance(Project project) {
        return project.getComponent(EditorNotifications.class);
    }

    public EditorNotifications(Project project, FileEditorManager fileEditorManager) {
        super(project);
        this.myFileEditorManager = fileEditorManager;
        project.getMessageBus().connect((Disposable)project).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerAdapter(){

            @Override
            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/EditorNotifications$2", "fileOpened"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ui/EditorNotifications$2", "fileOpened"));
                }
                EditorNotifications.this.updateNotifications(file);
            }
        });
    }

    public void updateNotifications(final VirtualFile file) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        FileEditor[] editors;
                        if (EditorNotifications.this.myProject.isDisposed()) {
                            return;
                        }
                        for (FileEditor editor : editors = EditorNotifications.this.myFileEditorManager.getAllEditors(file)) {
                            for (Provider provider : (Provider[])EditorNotifications.this.PROVIDERS.getValue()) {
                                Object component = provider.createNotificationPanel(file, editor);
                                Key key = provider.getKey();
                                EditorNotifications.this.updateNotification(editor, (Key<? extends JComponent>)key, component);
                            }
                        }
                    }
                });
            }
        });
    }

    public void updateAllNotifications() {
        VirtualFile[] files;
        for (VirtualFile file : files = this.myFileEditorManager.getOpenFiles()) {
            this.updateNotifications(file);
        }
    }

    private void updateNotification(FileEditor editor, Key<? extends JComponent> key, @Nullable JComponent component) {
        JComponent old = (JComponent)editor.getUserData(key);
        if (old != null) {
            this.myFileEditorManager.removeTopComponent(editor, old);
        }
        if (component != null) {
            this.myFileEditorManager.addTopComponent(editor, component);
            Key<? extends JComponent> _key = key;
            editor.putUserData(_key, component);
        } else {
            editor.putUserData(key, null);
        }
    }

    public static void updateAll() {
        Project[] projects;
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            EditorNotifications.getInstance(project).updateAllNotifications();
        }
    }

    public static abstract class Provider<T extends JComponent> {
        public abstract Key<T> getKey();

        @Nullable
        public abstract T createNotificationPanel(VirtualFile var1, FileEditor var2);
    }
}

