/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.AbstractFieldPanel;
import com.intellij.ui.DocumentAdapter;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ComboBoxFieldPanel
extends AbstractFieldPanel {
    private final JComboBox myComboBox = (JComboBox)this.getComponent();
    private String oldText;

    public ComboBoxFieldPanel() {
        super(new ComboBox());
    }

    public ComboBoxFieldPanel(String[] items, String labelText, String viewerDialogTitle, ActionListener browseButtonActionListener) {
        this(items, labelText, viewerDialogTitle, browseButtonActionListener, null);
    }

    public ComboBoxFieldPanel(String[] items, String labelText, String viewerDialogTitle, ActionListener browseButtonActionListener, Runnable documentListener) {
        super(new JComboBox<String>(items), labelText, viewerDialogTitle, browseButtonActionListener, documentListener);
        this.createComponent();
    }

    @Override
    public void createComponent() {
        super.createComponent();
        ComponentWithBrowseButton.MyDoClickAction doClickAction = this.getDoClickAction();
        if (doClickAction != null) {
            doClickAction.registerShortcut(this.myComboBox);
        }
        this.myComboBox.setMaximumRowCount(8);
        this.myComboBox.setEditable(true);
        JTextField editorComponent = (JTextField)this.myComboBox.getEditor().getEditorComponent();
        editorComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                String text = ComboBoxFieldPanel.this.getText();
                if (!Comparing.equal((String)text, (String)ComboBoxFieldPanel.this.oldText, (boolean)true)) {
                    ComboBoxFieldPanel.this.oldText = text;
                    Runnable changeListener = ComboBoxFieldPanel.this.getChangeListener();
                    if (changeListener != null) {
                        changeListener.run();
                    }
                }
            }
        });
    }

    @Override
    public String getText() {
        Object selectedItem = this.myComboBox.isEditable() ? this.myComboBox.getEditor().getItem() : this.myComboBox.getSelectedItem();
        return selectedItem instanceof String ? (String)selectedItem : null;
    }

    @Override
    public void setText(String text) {
        this.myComboBox.setSelectedItem(text);
    }

    public JComboBox getComboBox() {
        return this.myComboBox;
    }

    public void setItems(Object[] items) {
        this.myComboBox.removeAllItems();
        for (Object item : items) {
            this.myComboBox.addItem(item);
        }
    }

    public void addItemSetText(String text) {
        JComboBox comboBox = this.getComboBox();
        int n = comboBox.getItemCount();
        boolean found = false;
        for (int i = 0; i < n; ++i) {
            String item = (String)comboBox.getItemAt(i);
            if (!Comparing.strEqual((String)item, (String)text)) continue;
            found = true;
            break;
        }
        if (!found) {
            comboBox.addItem(text);
        }
        comboBox.getEditor().setItem(text);
        this.setText(text);
    }
}

