/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.ColorChooser;
import com.intellij.ui.UIBundle;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;

public class ColorPanel
extends JPanel {
    public static final Color DISABLED_COLOR = UIUtil.getPanelBackground();
    private boolean isFiringEvent = false;
    private ColorBox myFgSelectedColorBox;
    private boolean isEditable = true;

    public ColorPanel() {
        this(10);
    }

    public ColorPanel(int boxSize) {
        this.myFgSelectedColorBox = new ColorBox(null, (boxSize + 2) * 2, true);
        this.myFgSelectedColorBox.setSelectColorAction(new Runnable(){

            @Override
            public void run() {
                ColorPanel.this.fireActionEvent();
            }
        });
        JPanel selectedColorPanel = new JPanel(new GridBagLayout());
        selectedColorPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.myFgSelectedColorBox.setBorder(BorderFactory.createEtchedBorder());
        selectedColorPanel.add((Component)this.myFgSelectedColorBox, new GridBagConstraints());
        this.setLayout(new BorderLayout());
        this.add((Component)selectedColorPanel, "West");
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myFgSelectedColorBox.setEnabled(enabled);
        super.setEnabled(enabled);
        this.repaint();
    }

    private void fireActionEvent() {
        if (!this.isEditable) {
            return;
        }
        if (!this.isFiringEvent) {
            this.isFiringEvent = true;
            ActionEvent actionevent = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ActionListener.class) continue;
                if (actionevent == null) {
                    actionevent = new ActionEvent(this, 1001, "colorPanelChanged");
                }
                ((ActionListener)listeners[i + 1]).actionPerformed(actionevent);
            }
            this.isFiringEvent = false;
        }
    }

    public void removeActionListener(ActionListener actionlistener) {
        this.listenerList.remove(ActionListener.class, actionlistener);
    }

    public void addActionListener(ActionListener actionlistener) {
        this.listenerList.add(ActionListener.class, actionlistener);
    }

    public Color getSelectedColor() {
        return this.myFgSelectedColorBox.getColor();
    }

    public void setSelectedColor(Color color) {
        this.myFgSelectedColorBox.setColor(color);
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
        this.myFgSelectedColorBox.setSelectable(isEditable);
    }

    private class ColorBox
    extends JComponent {
        private final Dimension mySize;
        private boolean isSelectable;
        private Runnable mySelectColorAction = null;
        private Color myColor;
        @NonNls
        public static final String RGB = "RGB";

        public ColorBox(Color color, int size, boolean isSelectable) {
            this.mySize = new Dimension(size, size);
            this.isSelectable = isSelectable;
            this.myColor = color;
            this.updateToolTip();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent mouseevent) {
                    if (!ColorBox.this.isEnabled()) {
                        return;
                    }
                    if (mouseevent.isPopupTrigger()) {
                        ColorBox.this.selectColor();
                    }
                }

                @Override
                public void mousePressed(MouseEvent mouseevent) {
                    if (!ColorBox.this.isEnabled()) {
                        return;
                    }
                    if (mouseevent.getClickCount() == 2) {
                        ColorBox.this.selectColor();
                    } else if (SwingUtilities.isLeftMouseButton(mouseevent)) {
                        ColorPanel.this.setSelectedColor(ColorBox.this.myColor);
                        ColorPanel.this.fireActionEvent();
                    } else if (mouseevent.isPopupTrigger()) {
                        ColorBox.this.selectColor();
                    }
                }
            });
        }

        public void setSelectColorAction(Runnable selectColorAction) {
            this.mySelectColorAction = selectColorAction;
        }

        private void selectColor() {
            Color color;
            if (this.isSelectable && (color = ColorChooser.chooseColor(ColorPanel.this, UIBundle.message((String)"color.panel.select.color.dialog.description", (Object[])new Object[0]), this.myColor)) != null) {
                this.setColor(color);
                if (this.mySelectColorAction != null) {
                    this.mySelectColorAction.run();
                }
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.mySize;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.mySize;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.mySize;
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.isEnabled()) {
                g.setColor(this.myColor);
            } else {
                g.setColor(DISABLED_COLOR);
            }
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }

        private void updateToolTip() {
            if (this.myColor == null) {
                return;
            }
            StringBuilder buffer = new StringBuilder(64);
            buffer.append("RGB: ");
            buffer.append(this.myColor.getRed());
            buffer.append(", ");
            buffer.append(this.myColor.getGreen());
            buffer.append(", ");
            buffer.append(this.myColor.getBlue());
            if (this.isSelectable) {
                buffer.append(" (" + UIBundle.message((String)"color.panel.right.click.to.customize.tooltip.suffix", (Object[])new Object[0]) + ")");
            }
            this.setToolTipText(buffer.toString());
        }

        public void setColor(Color color) {
            this.myColor = color;
            this.updateToolTip();
            this.repaint();
        }

        public Color getColor() {
            return this.myColor;
        }

        private void setSelectable(boolean selectable) {
            this.isSelectable = selectable;
        }
    }
}

