/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckboxTreeBase
extends Tree {
    private final CheckPolicy myCheckPolicy;
    private static final CheckPolicy DEFAULT_POLICY = new CheckPolicy(true, true, false, true);

    public CheckboxTreeBase() {
        this(new CheckboxTreeCellRendererBase(), null);
    }

    public CheckboxTreeBase(CheckboxTreeCellRendererBase cellRenderer, CheckedTreeNode root) {
        this(cellRenderer, root, DEFAULT_POLICY);
    }

    public CheckboxTreeBase(CheckboxTreeCellRendererBase cellRenderer, @Nullable CheckedTreeNode root, CheckPolicy checkPolicy) {
        this.myCheckPolicy = checkPolicy;
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setLineStyleAngled();
        TreeUtil.installActions(this);
        this.installRenderer(cellRenderer);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (CheckboxTreeBase.this.isToggleEvent(e)) {
                    TreePath treePath = CheckboxTreeBase.this.getLeadSelectionPath();
                    if (treePath == null) {
                        return;
                    }
                    Object o = treePath.getLastPathComponent();
                    if (!(o instanceof CheckedTreeNode)) {
                        return;
                    }
                    CheckedTreeNode firstNode = (CheckedTreeNode)o;
                    boolean checked = CheckboxTreeBase.this.toggleNode(firstNode);
                    TreePath[] selectionPaths = CheckboxTreeBase.this.getSelectionPaths();
                    for (int i = 0; selectionPaths != null && i < selectionPaths.length; ++i) {
                        TreePath selectionPath = selectionPaths[i];
                        Object o1 = selectionPath.getLastPathComponent();
                        if (!(o1 instanceof CheckedTreeNode)) continue;
                        CheckedTreeNode node = (CheckedTreeNode)o1;
                        CheckboxTreeBase.this.checkNode(node, checked);
                        ((DefaultTreeModel)CheckboxTreeBase.this.getModel()).nodeChanged(node);
                    }
                    e.consume();
                }
            }
        });
        this.setSelectionRow(0);
        if (root != null) {
            this.setModel(new DefaultTreeModel(root));
        }
    }

    public void installRenderer(final CheckboxTreeCellRendererBase cellRenderer) {
        this.setCellRenderer(cellRenderer);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/CheckboxTreeBase$2", "onClick"));
                }
                int row = CheckboxTreeBase.this.getRowForLocation(e.getX(), e.getY());
                if (row < 0) {
                    return false;
                }
                Object o = CheckboxTreeBase.this.getPathForRow(row).getLastPathComponent();
                if (!(o instanceof CheckedTreeNode)) {
                    return false;
                }
                Rectangle rowBounds = CheckboxTreeBase.this.getRowBounds(row);
                cellRenderer.setBounds(rowBounds);
                Rectangle checkBounds = cellRenderer.myCheckbox.getBounds();
                checkBounds.setLocation(rowBounds.getLocation());
                if (checkBounds.height == 0) {
                    checkBounds.height = checkBounds.width = rowBounds.height;
                }
                CheckedTreeNode node = (CheckedTreeNode)o;
                if (checkBounds.contains(e.getPoint())) {
                    if (node.isEnabled()) {
                        CheckboxTreeBase.this.toggleNode(node);
                        CheckboxTreeBase.this.setSelectionRow(row);
                        return true;
                    }
                } else if (clickCount > 1) {
                    CheckboxTreeBase.this.onDoubleClick(node);
                    return true;
                }
                return false;
            }
        }.installOn((Component)this);
    }

    protected void onDoubleClick(CheckedTreeNode node) {
    }

    protected boolean isToggleEvent(KeyEvent e) {
        return e.getKeyCode() == 32;
    }

    protected boolean toggleNode(CheckedTreeNode node) {
        boolean checked = !node.isChecked();
        this.checkNode(node, checked);
        TreeModel model = this.getModel();
        model.valueForPathChanged(new TreePath(node.getPath()), node.getUserObject());
        return checked;
    }

    public <T> T[] getCheckedNodes(final Class<T> nodeType, final @Nullable Tree.NodeFilter<T> filter) {
        final ArrayList nodes = new ArrayList();
        Object root = this.getModel().getRoot();
        if (!(root instanceof CheckedTreeNode)) {
            throw new IllegalStateException("The root must be instance of the " + CheckedTreeNode.class.getName() + ": " + root.getClass().getName());
        }
        new Object(){

            public void collect(CheckedTreeNode node) {
                if (node.isLeaf()) {
                    Object userObject = node.getUserObject();
                    if (node.isChecked() && userObject != null && nodeType.isAssignableFrom(userObject.getClass())) {
                        Object value = userObject;
                        if (filter != null && !filter.accept(value)) {
                            return;
                        }
                        nodes.add(value);
                    }
                } else {
                    for (int i = 0; i < node.getChildCount(); ++i) {
                        TreeNode child = node.getChildAt(i);
                        if (!(child instanceof CheckedTreeNode)) continue;
                        this.collect((CheckedTreeNode)child);
                    }
                }
            }
        }.collect((CheckedTreeNode)root);
        Object[] result = (Object[])Array.newInstance(nodeType, nodes.size());
        nodes.toArray(result);
        return result;
    }

    @Override
    public int getToggleClickCount() {
        return -1;
    }

    protected void checkNode(CheckedTreeNode node, boolean checked) {
        this.adjustParentsAndChildren(node, checked);
        this.repaint();
    }

    protected void onNodeStateChanged(CheckedTreeNode node) {
    }

    protected void nodeStateWillChange(CheckedTreeNode node) {
    }

    protected void adjustParentsAndChildren(CheckedTreeNode node, boolean checked) {
        this.changeNodeState(node, checked);
        if (!checked) {
            if (this.myCheckPolicy.uncheckParentWithUncheckedChild) {
                for (TreeNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof CheckedTreeNode)) continue;
                    this.changeNodeState((CheckedTreeNode)parent, false);
                }
            }
            if (this.myCheckPolicy.uncheckChildrenWithUncheckedParent) {
                this.uncheckChildren(node);
            }
        } else {
            if (this.myCheckPolicy.checkChildrenWithCheckedParent) {
                this.checkChildren(node);
            }
            if (this.myCheckPolicy.checkParentWithCheckedChild) {
                for (TreeNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof CheckedTreeNode)) continue;
                    this.changeNodeState((CheckedTreeNode)parent, true);
                }
            }
        }
        this.repaint();
    }

    private void changeNodeState(CheckedTreeNode node, boolean checked) {
        if (node.isChecked() != checked) {
            this.nodeStateWillChange(node);
            node.setChecked(checked);
            this.onNodeStateChanged(node);
        }
    }

    private void uncheckChildren(CheckedTreeNode node) {
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            TreeNode o = children.nextElement();
            if (!(o instanceof CheckedTreeNode)) continue;
            CheckedTreeNode child = (CheckedTreeNode)o;
            this.changeNodeState(child, false);
            this.uncheckChildren(child);
        }
    }

    private void checkChildren(CheckedTreeNode node) {
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            TreeNode o = children.nextElement();
            if (!(o instanceof CheckedTreeNode)) continue;
            CheckedTreeNode child = (CheckedTreeNode)o;
            this.changeNodeState(child, true);
            this.checkChildren(child);
        }
    }

    protected void adjustParents(CheckedTreeNode node, boolean checked) {
        TreeNode parentNode = node.getParent();
        if (!(parentNode instanceof CheckedTreeNode)) {
            return;
        }
        CheckedTreeNode parent = (CheckedTreeNode)parentNode;
        if (!checked && CheckboxTreeBase.isAllChildrenUnchecked(parent)) {
            this.changeNodeState(parent, false);
            this.adjustParents(parent, false);
        } else if (checked && CheckboxTreeBase.isAllChildrenChecked(parent)) {
            this.changeNodeState(parent, true);
            this.adjustParents(parent, true);
        }
    }

    private static boolean isAllChildrenUnchecked(CheckedTreeNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeNode o = node.getChildAt(i);
            if (!(o instanceof CheckedTreeNode) || !((CheckedTreeNode)o).isChecked()) continue;
            return false;
        }
        return true;
    }

    private static boolean isAllChildrenChecked(CheckedTreeNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeNode o = node.getChildAt(i);
            if (!(o instanceof CheckedTreeNode) || ((CheckedTreeNode)o).isChecked()) continue;
            return false;
        }
        return true;
    }

    public static class CheckPolicy {
        final boolean checkChildrenWithCheckedParent;
        final boolean uncheckChildrenWithUncheckedParent;
        final boolean checkParentWithCheckedChild;
        final boolean uncheckParentWithUncheckedChild;

        public CheckPolicy(boolean checkChildrenWithCheckedParent, boolean uncheckChildrenWithUncheckedParent, boolean checkParentWithCheckedChild, boolean uncheckParentWithUncheckedChild) {
            this.checkChildrenWithCheckedParent = checkChildrenWithCheckedParent;
            this.uncheckChildrenWithUncheckedParent = uncheckChildrenWithUncheckedParent;
            this.checkParentWithCheckedChild = checkParentWithCheckedChild;
            this.uncheckParentWithUncheckedChild = uncheckParentWithUncheckedChild;
        }
    }

    public static enum NodeState {
        FULL,
        CLEAR,
        PARTIAL;

    }

    public static class CheckboxTreeCellRendererBase
    extends JPanel
    implements TreeCellRenderer {
        private final ColoredTreeCellRenderer myTextRenderer;
        public final JCheckBox myCheckbox;
        private final boolean myUsePartialStatusForParentNodes;

        public CheckboxTreeCellRendererBase(boolean opaque) {
            this(opaque, true);
        }

        public CheckboxTreeCellRendererBase(boolean opaque, boolean usePartialStatusForParentNodes) {
            super(new BorderLayout());
            this.myUsePartialStatusForParentNodes = usePartialStatusForParentNodes;
            this.myCheckbox = new JCheckBox();
            this.myTextRenderer = new ColoredTreeCellRenderer(){

                @Override
                public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                }
            };
            this.myTextRenderer.setOpaque(opaque);
            this.add((Component)this.myCheckbox, "West");
            this.add((Component)this.myTextRenderer, "Center");
        }

        public CheckboxTreeCellRendererBase() {
            this(true);
        }

        @Override
        public final Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.invalidate();
            if (value instanceof CheckedTreeNode) {
                CheckedTreeNode node = (CheckedTreeNode)value;
                NodeState state = this.getNodeStatus(node);
                this.myCheckbox.setVisible(true);
                this.myCheckbox.setSelected(state != NodeState.CLEAR);
                this.myCheckbox.setEnabled(node.isEnabled() && state != NodeState.PARTIAL);
                this.myCheckbox.setOpaque(false);
                this.myCheckbox.setBackground(null);
                this.setBackground(null);
            } else {
                this.myCheckbox.setVisible(false);
            }
            this.myTextRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (UIUtil.isUnderGTKLookAndFeel()) {
                Color background = selected ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeTextBackground();
                UIUtil.changeBackGround((Component)this, (Color)background);
            } else if (UIUtil.isUnderNimbusLookAndFeel()) {
                UIUtil.changeBackGround((Component)this, (Color)UIUtil.TRANSPARENT_COLOR);
            }
            this.customizeRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
            this.revalidate();
            return this;
        }

        private NodeState getNodeStatus(CheckedTreeNode node) {
            boolean checked = node.isChecked();
            if (node.getChildCount() == 0 || !this.myUsePartialStatusForParentNodes) {
                return checked ? NodeState.FULL : NodeState.CLEAR;
            }
            NodeState result = null;
            for (int i = 0; i < node.getChildCount(); ++i) {
                NodeState childStatus;
                TreeNode child = node.getChildAt(i);
                NodeState nodeState = child instanceof CheckedTreeNode ? this.getNodeStatus((CheckedTreeNode)child) : (childStatus = checked ? NodeState.FULL : NodeState.CLEAR);
                if (childStatus == NodeState.PARTIAL) {
                    return NodeState.PARTIAL;
                }
                if (result == null) {
                    result = childStatus;
                    continue;
                }
                if (result == childStatus) continue;
                return NodeState.PARTIAL;
            }
            return result == null ? NodeState.CLEAR : result;
        }

        public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof CheckedTreeNode) {
                this.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
            }
        }

        @Deprecated
        public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        }

        public ColoredTreeCellRenderer getTextRenderer() {
            return this.myTextRenderer;
        }

        public JCheckBox getCheckbox() {
            return this.myCheckbox;
        }
    }
}

