/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.compiler.CompilerManagerImpl;
import com.intellij.compiler.CompilerTestUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.TempDirTestFixtureImpl;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class CompilerTester {
    private final boolean myExternalMake;
    private final Module myModule;
    private TempDirTestFixture myMainOutput;

    public CompilerTester(boolean externalMake, Module module) throws Exception {
        this.myExternalMake = externalMake;
        this.myModule = module;
        this.myMainOutput = new TempDirTestFixtureImpl();
        this.myMainOutput.setUp();
        CompilerManagerImpl.testSetup();
        new WriteCommandAction(this.getProject(), new PsiFile[0]){

            @Override
            protected void run(Result result) throws Throwable {
                CompilerProjectExtension.getInstance(this.getProject()).setCompilerOutputUrl(CompilerTester.this.myMainOutput.findOrCreateDir("out").getUrl());
                if (CompilerTester.this.myExternalMake) {
                    CompilerTestUtil.enableExternalCompiler(this.getProject());
                    ModuleRootModificationUtil.setModuleSdk((Module)CompilerTester.this.myModule, (Sdk)JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk());
                } else {
                    CompilerTestUtil.disableExternalCompiler(this.getProject());
                }
            }
        }.execute();
    }

    public void tearDown() {
        if (this.myExternalMake) {
            CompilerTestUtil.disableExternalCompiler(this.getProject());
        }
        try {
            this.myMainOutput.tearDown();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.myMainOutput = null;
    }

    private Project getProject() {
        return this.myModule.getProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteClassFile(String className) throws IOException {
        AccessToken token = WriteAction.start();
        try {
            if (this.myExternalMake) {
                this.touch(JavaPsiFacade.getInstance(this.getProject()).findClass(className, GlobalSearchScope.allScope(this.getProject())).getContainingFile().getVirtualFile());
            } else {
                this.findClassFile(className, this.myModule).delete(this);
            }
        }
        finally {
            token.finish();
        }
    }

    @Nullable
    public VirtualFile findClassFile(String className, Module module) {
        VirtualFile path = ModuleRootManager.getInstance(module).getModuleExtension(CompilerModuleExtension.class).getCompilerOutputPath();
        path.getChildren();
        assert (path != null);
        path.refresh(false, true);
        return path.findChild(className.replace('.', '/') + ".class");
    }

    public void touch(VirtualFile file) throws IOException {
        file.setBinaryContent(file.contentsToByteArray(), -1L, file.getTimeStamp() + 1L);
        File ioFile = VfsUtil.virtualToIoFile(file);
        assert (ioFile.setLastModified(ioFile.lastModified() - 100000L));
        file.refresh(false, false);
    }

    public void setFileText(final PsiFile file, final String text) throws IOException {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    VirtualFile virtualFile = file.getVirtualFile();
                    VfsUtil.saveText((VirtualFile)ObjectUtils.assertNotNull((Object)virtualFile), text);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.touch(file.getVirtualFile());
    }

    public void setFileName(final PsiFile file, final String name) {
        new WriteCommandAction(this.getProject(), new PsiFile[0]){

            @Override
            protected void run(Result result) throws Throwable {
                file.setName(name);
            }
        }.execute();
    }

    public List<CompilerMessage> make() {
        return this.runCompiler(new Consumer<ErrorReportingCallback>(){

            public void consume(ErrorReportingCallback callback) {
                CompilerManager.getInstance(CompilerTester.this.getProject()).make(callback);
            }
        });
    }

    public List<CompilerMessage> rebuild() {
        return this.runCompiler(new Consumer<ErrorReportingCallback>(){

            public void consume(ErrorReportingCallback callback) {
                CompilerManager.getInstance(CompilerTester.this.getProject()).rebuild(callback);
            }
        });
    }

    public List<CompilerMessage> compileModule(final Module module) {
        return this.runCompiler(new Consumer<ErrorReportingCallback>(){

            public void consume(ErrorReportingCallback callback) {
                CompilerManager.getInstance(CompilerTester.this.getProject()).compile(module, (CompileStatusNotification)callback);
            }
        });
    }

    public List<CompilerMessage> compileFiles(final VirtualFile ... files) {
        return this.runCompiler(new Consumer<ErrorReportingCallback>(){

            public void consume(ErrorReportingCallback callback) {
                CompilerManager.getInstance(CompilerTester.this.getProject()).compile(files, (CompileStatusNotification)callback);
            }
        });
    }

    private List<CompilerMessage> runCompiler(final Consumer<ErrorReportingCallback> runnable) {
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        final ErrorReportingCallback callback = new ErrorReportingCallback(semaphore);
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (CompilerTester.this.myExternalMake) {
                        CompilerTester.this.getProject().save();
                        CompilerTestUtil.saveApplicationSettings();
                        File ioFile = VfsUtil.virtualToIoFile(CompilerTester.this.myModule.getModuleFile());
                        if (!ioFile.exists()) {
                            CompilerTester.this.getProject().save();
                            assert (ioFile.exists()) : "File does not exist: " + ioFile.getPath();
                        }
                    }
                    runnable.consume((Object)callback);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        while (!semaphore.waitFor(100L)) {
            if (!SwingUtilities.isEventDispatchThread()) continue;
            UIUtil.dispatchAllInvocationEvents();
        }
        callback.throwException();
        return callback.getMessages();
    }

    private static class ErrorReportingCallback
    implements CompileStatusNotification {
        private final Semaphore mySemaphore;
        private Throwable myError;
        private final List<CompilerMessage> myMessages = new ArrayList<CompilerMessage>();

        public ErrorReportingCallback(Semaphore semaphore) {
            this.mySemaphore = semaphore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
            try {
                for (CompilerMessageCategory category : CompilerMessageCategory.values()) {
                    CompilerMessage[] messages;
                    for (CompilerMessage message : messages = compileContext.getMessages(category)) {
                        String text = message.getMessage();
                        if (category == CompilerMessageCategory.INFORMATION && (text.startsWith("Compilation completed successfully") || text.startsWith("Using javac"))) continue;
                        this.myMessages.add(message);
                    }
                }
                Assert.assertFalse((String)"Code did not compile!", (boolean)aborted);
            }
            catch (Throwable t) {
                this.myError = t;
            }
            finally {
                this.mySemaphore.up();
            }
        }

        void throwException() {
            if (this.myError != null) {
                throw new RuntimeException(this.myError);
            }
        }

        public List<CompilerMessage> getMessages() {
            return this.myMessages;
        }
    }
}

