/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameInputValidator;
import com.intellij.refactoring.rename.RenameInputValidatorEx;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.Nullable;

public class RenameInputValidatorRegistry {
    private RenameInputValidatorRegistry() {
    }

    @Nullable
    public static Condition<String> getInputValidator(final PsiElement element) {
        for (final RenameInputValidator validator : (RenameInputValidator[])Extensions.getExtensions(RenameInputValidator.EP_NAME)) {
            final ProcessingContext context = new ProcessingContext();
            if (!validator.getPattern().accepts(element, context)) continue;
            return new Condition<String>(){

                public boolean value(String s) {
                    return validator.isInputValid(s, element, context);
                }
            };
        }
        return null;
    }

    @Nullable
    public static Function<String, String> getInputErrorValidator(final PsiElement element) {
        for (final RenameInputValidator validator : (RenameInputValidator[])Extensions.getExtensions(RenameInputValidator.EP_NAME)) {
            if (!(validator instanceof RenameInputValidatorEx)) continue;
            ProcessingContext context = new ProcessingContext();
            if (!validator.getPattern().accepts(element, context)) continue;
            return new Function<String, String>(){

                public String fun(String newName) {
                    return ((RenameInputValidatorEx)validator).getErrorMessage(newName, element.getProject());
                }
            };
        }
        return null;
    }
}

