/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.reference.SoftReference;
import com.intellij.util.Function;
import java.lang.ref.Reference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiCacheKey<T, H extends PsiElement>
extends Key<SoftReference<Pair<Long, T>>> {
    private final Function<H, T> myFunction;

    private PsiCacheKey(@NonNls @NotNull String name, @NotNull Function<H, T> function) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/util/PsiCacheKey", "<init>"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/util/PsiCacheKey", "<init>"));
        }
        super(name);
        this.myFunction = function;
    }

    public final T getValue(@NotNull H h) {
        if (h == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/util/PsiCacheKey", "getValue"));
        }
        Object result = this.getCachedValueOrNull(h);
        if (result != null) {
            return result;
        }
        result = this.myFunction.fun(h);
        long count = h.getManager().getModificationTracker().getJavaStructureModificationCount();
        h.putUserData((Key)this, (Object)new SoftReference((Object)new Pair((Object)count, result)));
        return result;
    }

    @Nullable
    public final T getCachedValueOrNull(@NotNull H h) {
        if (h == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/util/PsiCacheKey", "getCachedValueOrNull"));
        }
        SoftReference ref = (SoftReference)h.getUserData((Key)this);
        Pair data = (Pair)SoftReference.dereference((Reference)ref);
        if (data == null || ((Long)data.getFirst()).longValue() != h.getManager().getModificationTracker().getJavaStructureModificationCount()) {
            return null;
        }
        return (T)data.getSecond();
    }

    public static <T, H extends PsiElement> PsiCacheKey<T, H> create(@NonNls @NotNull String name, @NotNull Function<H, T> function) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/util/PsiCacheKey", "create"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/util/PsiCacheKey", "create"));
        }
        return new PsiCacheKey<T, H>(name, function);
    }
}

