/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.util.Query;
import com.intellij.util.QueryFactory;
import org.jetbrains.annotations.NotNull;

public abstract class IndexPatternSearch
extends QueryFactory<IndexPatternOccurrence, SearchParameters> {
    public static IndexPatternSearch INDEX_PATTERN_SEARCH_INSTANCE = ServiceManager.getService(IndexPatternSearch.class);

    protected IndexPatternSearch() {
    }

    public static Query<IndexPatternOccurrence> search(@NotNull PsiFile file, @NotNull IndexPattern pattern) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/searches/IndexPatternSearch", "search"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/searches/IndexPatternSearch", "search"));
        }
        SearchParameters parameters = new SearchParameters(file, pattern);
        return INDEX_PATTERN_SEARCH_INSTANCE.createQuery(parameters);
    }

    public static Query<IndexPatternOccurrence> search(@NotNull PsiFile file, @NotNull IndexPattern pattern, int startOffset, int endOffset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/searches/IndexPatternSearch", "search"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/searches/IndexPatternSearch", "search"));
        }
        SearchParameters parameters = new SearchParameters(file, pattern, new TextRange(startOffset, endOffset));
        return INDEX_PATTERN_SEARCH_INSTANCE.createQuery(parameters);
    }

    public static Query<IndexPatternOccurrence> search(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/searches/IndexPatternSearch", "search"));
        }
        if (patternProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/searches/IndexPatternSearch", "search"));
        }
        SearchParameters parameters = new SearchParameters(file, patternProvider);
        return INDEX_PATTERN_SEARCH_INSTANCE.createQuery(parameters);
    }

    public static Query<IndexPatternOccurrence> search(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider, int startOffset, int endOffset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/searches/IndexPatternSearch", "search"));
        }
        if (patternProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/searches/IndexPatternSearch", "search"));
        }
        SearchParameters parameters = new SearchParameters(file, patternProvider, new TextRange(startOffset, endOffset));
        return INDEX_PATTERN_SEARCH_INSTANCE.createQuery(parameters);
    }

    public static int getOccurrencesCount(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/searches/IndexPatternSearch", "getOccurrencesCount"));
        }
        if (patternProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/searches/IndexPatternSearch", "getOccurrencesCount"));
        }
        return INDEX_PATTERN_SEARCH_INSTANCE.getOccurrencesCountImpl(file, patternProvider);
    }

    public static int getOccurrencesCount(@NotNull PsiFile file, @NotNull IndexPattern pattern) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/searches/IndexPatternSearch", "getOccurrencesCount"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/searches/IndexPatternSearch", "getOccurrencesCount"));
        }
        return INDEX_PATTERN_SEARCH_INSTANCE.getOccurrencesCountImpl(file, pattern);
    }

    protected abstract int getOccurrencesCountImpl(@NotNull PsiFile var1, @NotNull IndexPatternProvider var2);

    protected abstract int getOccurrencesCountImpl(@NotNull PsiFile var1, @NotNull IndexPattern var2);

    public static class SearchParameters {
        private final PsiFile myFile;
        private final IndexPattern myPattern;
        private final IndexPatternProvider myPatternProvider;
        private final TextRange myRange;

        public SearchParameters(@NotNull PsiFile file, @NotNull IndexPattern pattern) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/searches/IndexPatternSearch$SearchParameters", "<init>"));
            }
            if (pattern == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/searches/IndexPatternSearch$SearchParameters", "<init>"));
            }
            this(file, pattern, null);
        }

        public SearchParameters(@NotNull PsiFile file, @NotNull IndexPattern pattern, TextRange range) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/searches/IndexPatternSearch$SearchParameters", "<init>"));
            }
            if (pattern == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/searches/IndexPatternSearch$SearchParameters", "<init>"));
            }
            this.myFile = file;
            this.myRange = range;
            this.myPatternProvider = null;
            this.myPattern = pattern;
        }

        public SearchParameters(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/searches/IndexPatternSearch$SearchParameters", "<init>"));
            }
            if (patternProvider == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/searches/IndexPatternSearch$SearchParameters", "<init>"));
            }
            this(file, patternProvider, null);
        }

        public SearchParameters(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider, TextRange range) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/searches/IndexPatternSearch$SearchParameters", "<init>"));
            }
            if (patternProvider == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/searches/IndexPatternSearch$SearchParameters", "<init>"));
            }
            this.myFile = file;
            this.myPatternProvider = patternProvider;
            this.myRange = range;
            this.myPattern = null;
        }

        public PsiFile getFile() {
            return this.myFile;
        }

        public IndexPattern getPattern() {
            return this.myPattern;
        }

        public IndexPatternProvider getPatternProvider() {
            return this.myPatternProvider;
        }

        public TextRange getRange() {
            return this.myRange;
        }
    }
}

