/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

public class FunctionalExpressionSearch
extends ExtensibleQueryFactory<PsiFunctionalExpression, SearchParameters> {
    public static ExtensionPointName<QueryExecutor> EP_NAME = ExtensionPointName.create((String)"com.intellij.functionalInterfaceSearch");
    public static final FunctionalExpressionSearch INSTANCE = new FunctionalExpressionSearch();

    public static Query<PsiFunctionalExpression> search(PsiClass aClass, SearchScope scope) {
        return INSTANCE.createUniqueResultsQuery(new SearchParameters(aClass, scope));
    }

    public static Query<PsiFunctionalExpression> search(PsiMethod psiMethod) {
        return FunctionalExpressionSearch.search(psiMethod, (SearchScope)GlobalSearchScope.allScope(psiMethod.getProject()));
    }

    public static Query<PsiFunctionalExpression> search(PsiMethod psiMethod, SearchScope scope) {
        if (!psiMethod.hasModifierProperty("static") && !psiMethod.hasModifierProperty("default")) {
            return INSTANCE.createUniqueResultsQuery(new SearchParameters(psiMethod.getContainingClass(), scope));
        }
        return EmptyQuery.getEmptyQuery();
    }

    public static Query<PsiFunctionalExpression> search(PsiClass aClass) {
        return FunctionalExpressionSearch.search(aClass, (SearchScope)GlobalSearchScope.allScope(aClass.getProject()));
    }

    public static class SearchParameters {
        private final PsiClass myElementToSearch;
        private final SearchScope myScope;

        public SearchParameters(PsiClass aClass, SearchScope scope) {
            this.myElementToSearch = aClass;
            this.myScope = scope;
        }

        public PsiClass getElementToSearch() {
            return this.myElementToSearch;
        }

        @NotNull
        public SearchScope getEffectiveSearchScope() {
            SearchScope accessScope = PsiSearchHelper.SERVICE.getInstance(this.myElementToSearch.getProject()).getUseScope(this.myElementToSearch);
            SearchScope searchScope = this.myScope.intersectWith(accessScope);
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/FunctionalExpressionSearch$SearchParameters", "getEffectiveSearchScope"));
            }
            return searchScope;
        }
    }
}

