/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class NonClasspathDirectoriesScope
extends GlobalSearchScope {
    private final Set<VirtualFile> myRoots;

    public NonClasspathDirectoriesScope(@NotNull Collection<VirtualFile> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/NonClasspathDirectoriesScope", "<init>"));
        }
        this.myRoots = ContainerUtil.newHashSet(roots);
    }

    @Override
    public boolean isSearchOutsideRootModel() {
        return true;
    }

    @NotNull
    public static GlobalSearchScope compose(List<VirtualFile> roots) {
        if (roots.isEmpty()) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/NonClasspathDirectoriesScope", "compose"));
            }
            return globalSearchScope;
        }
        NonClasspathDirectoriesScope nonClasspathDirectoriesScope = new NonClasspathDirectoriesScope(roots);
        if (nonClasspathDirectoriesScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/NonClasspathDirectoriesScope", "compose"));
        }
        return nonClasspathDirectoriesScope;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/NonClasspathDirectoriesScope", "contains"));
        }
        return VfsUtilCore.isUnder(file, this.myRoots);
    }

    @Override
    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/NonClasspathDirectoriesScope", "compare"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/NonClasspathDirectoriesScope", "compare"));
        }
        return 0;
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/NonClasspathDirectoriesScope", "isSearchInModuleContent"));
        }
        return false;
    }

    @Override
    public boolean isSearchInLibraries() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NonClasspathDirectoriesScope)) {
            return false;
        }
        NonClasspathDirectoriesScope that = (NonClasspathDirectoriesScope)o;
        return ((Object)this.myRoots).equals(that.myRoots);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + ((Object)this.myRoots).hashCode();
        return result;
    }
}

