/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;

public class IndexPattern {
    @NotNull
    private String myPatternString;
    private boolean myCaseSensitive;
    private Pattern myPattern;

    public IndexPattern(@NotNull String patternString, boolean caseSensitive) {
        if (patternString == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/IndexPattern", "<init>"));
        }
        this.myPatternString = patternString;
        this.myCaseSensitive = caseSensitive;
        this.compilePattern();
    }

    @NotNull
    public String getPatternString() {
        String string = this.myPatternString;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/IndexPattern", "getPatternString"));
        }
        return string;
    }

    public Pattern getPattern() {
        return this.myPattern;
    }

    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    public void setPatternString(@NotNull String patternString) {
        if (patternString == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/IndexPattern", "setPatternString"));
        }
        this.myPatternString = patternString;
        this.compilePattern();
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.myCaseSensitive = caseSensitive;
        this.compilePattern();
    }

    private void compilePattern() {
        try {
            this.myPattern = this.myCaseSensitive ? Pattern.compile(this.myPatternString) : Pattern.compile(this.myPatternString, 2);
        }
        catch (PatternSyntaxException e) {
            this.myPattern = null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexPattern that = (IndexPattern)o;
        if (this.myCaseSensitive != that.myCaseSensitive) {
            return false;
        }
        return this.myPatternString.equals(that.myPatternString);
    }

    public int hashCode() {
        int result = this.myPatternString.hashCode();
        result = 29 * result + (this.myCaseSensitive ? 1 : 0);
        return result;
    }
}

