/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.include;

import org.jetbrains.annotations.NotNull;

public class FileIncludeInfo {
    public final String fileName;
    public final String path;
    public final int offset;
    public final boolean runtimeOnly;
    public static final FileIncludeInfo[] EMPTY = new FileIncludeInfo[0];

    public FileIncludeInfo(@NotNull String fileName, @NotNull String path, int offset, boolean runtimeOnly) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/include/FileIncludeInfo", "<init>"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/include/FileIncludeInfo", "<init>"));
        }
        this.fileName = fileName;
        this.path = path;
        this.offset = offset;
        this.runtimeOnly = runtimeOnly;
    }

    public FileIncludeInfo(@NotNull String path, int offset) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/include/FileIncludeInfo", "<init>"));
        }
        this(FileIncludeInfo.getFileName(path), path, offset, false);
    }

    public FileIncludeInfo(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/include/FileIncludeInfo", "<init>"));
        }
        this(path, -1);
    }

    private static String getFileName(String path) {
        int pos = path.lastIndexOf(47);
        return pos == -1 ? path : path.substring(pos + 1);
    }
}

