/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.std;

import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StdArrangementSettings
implements ArrangementSettings {
    @NotNull
    private final List<ArrangementGroupingRule> myGroupings;
    @NotNull
    protected final List<StdArrangementMatchRule> myRules;

    public StdArrangementSettings() {
        this.myGroupings = new ArrayList<ArrangementGroupingRule>();
        this.myRules = new ArrayList<StdArrangementMatchRule>();
    }

    public StdArrangementSettings(@NotNull List<StdArrangementMatchRule> rules) {
        if (rules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings", "<init>"));
        }
        this(Collections.EMPTY_LIST, rules);
    }

    public StdArrangementSettings(@NotNull List<ArrangementGroupingRule> groupingRules, @NotNull List<StdArrangementMatchRule> matchRules) {
        if (groupingRules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings", "<init>"));
        }
        if (matchRules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings", "<init>"));
        }
        this.myGroupings = new ArrayList<ArrangementGroupingRule>();
        this.myRules = new ArrayList<StdArrangementMatchRule>();
        this.myGroupings.addAll(groupingRules);
        this.myRules.addAll(matchRules);
    }

    @NotNull
    public List<StdArrangementMatchRule> getRules() {
        List<StdArrangementMatchRule> list = this.myRules;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings", "getRules"));
        }
        return list;
    }

    @NotNull
    protected List<ArrangementGroupingRule> cloneGroupings() {
        ArrayList<ArrangementGroupingRule> groupings = new ArrayList<ArrangementGroupingRule>();
        for (ArrangementGroupingRule grouping : this.myGroupings) {
            groupings.add(grouping.clone());
        }
        ArrayList<ArrangementGroupingRule> arrayList = groupings;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings", "cloneGroupings"));
        }
        return arrayList;
    }

    @NotNull
    protected List<StdArrangementMatchRule> cloneMatchRules() {
        ArrayList<StdArrangementMatchRule> rules = new ArrayList<StdArrangementMatchRule>();
        for (StdArrangementMatchRule rule : this.myRules) {
            rules.add(rule.clone());
        }
        ArrayList<StdArrangementMatchRule> arrayList = rules;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings", "cloneMatchRules"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public ArrangementSettings clone() {
        StdArrangementSettings stdArrangementSettings = new StdArrangementSettings(this.cloneGroupings(), this.cloneMatchRules());
        if (stdArrangementSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings", "clone"));
        }
        return stdArrangementSettings;
    }

    @Override
    @NotNull
    public List<ArrangementGroupingRule> getGroupings() {
        List<ArrangementGroupingRule> list = this.myGroupings;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings", "getGroupings"));
        }
        return list;
    }

    public void addRule(@NotNull StdArrangementMatchRule rule) {
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings", "addRule"));
        }
        this.myRules.add(rule);
    }

    public void addGrouping(@NotNull ArrangementGroupingRule rule) {
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings", "addGrouping"));
        }
        this.myGroupings.add(rule);
    }

    public int hashCode() {
        int result = ((Object)this.myRules).hashCode();
        result = 31 * result + ((Object)this.myGroupings).hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StdArrangementSettings settings = (StdArrangementSettings)o;
        if (!((Object)this.myGroupings).equals(settings.myGroupings)) {
            return false;
        }
        return ((Object)this.myRules).equals(settings.myRules);
    }
}

