/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.model;

import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import org.jetbrains.annotations.NotNull;

public class ArrangementAtomMatchCondition
implements ArrangementMatchCondition {
    @NotNull
    private final ArrangementSettingsToken myType;
    @NotNull
    private final Object myValue;
    private boolean myInverted;

    public ArrangementAtomMatchCondition(@NotNull ArrangementSettingsToken type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/model/ArrangementAtomMatchCondition", "<init>"));
        }
        this(type, type);
    }

    public ArrangementAtomMatchCondition(@NotNull ArrangementSettingsToken type, @NotNull Object value) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/model/ArrangementAtomMatchCondition", "<init>"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/model/ArrangementAtomMatchCondition", "<init>"));
        }
        this.myType = type;
        this.myValue = value;
    }

    @NotNull
    public ArrangementSettingsToken getType() {
        ArrangementSettingsToken arrangementSettingsToken = this.myType;
        if (arrangementSettingsToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/model/ArrangementAtomMatchCondition", "getType"));
        }
        return arrangementSettingsToken;
    }

    @NotNull
    public Object getValue() {
        Object object = this.myValue;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/model/ArrangementAtomMatchCondition", "getValue"));
        }
        return object;
    }

    @Override
    public void invite(@NotNull ArrangementMatchConditionVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/model/ArrangementAtomMatchCondition", "invite"));
        }
        visitor.visit(this);
    }

    public void setInverted(boolean inverted) {
        this.myInverted = inverted;
    }

    public int hashCode() {
        int result = this.myType.hashCode();
        result = 31 * result + this.myValue.hashCode();
        result = 31 * result + (this.myInverted ? 1 : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrangementAtomMatchCondition setting = (ArrangementAtomMatchCondition)o;
        if (this.myInverted != setting.myInverted) {
            return false;
        }
        if (!this.myType.equals(setting.myType)) {
            return false;
        }
        return this.myValue.equals(setting.myValue);
    }

    @Override
    @NotNull
    public ArrangementAtomMatchCondition clone() {
        ArrangementAtomMatchCondition result = new ArrangementAtomMatchCondition(this.myType, this.myValue);
        result.setInverted(this.myInverted);
        ArrangementAtomMatchCondition arrangementAtomMatchCondition = result;
        if (arrangementAtomMatchCondition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/model/ArrangementAtomMatchCondition", "clone"));
        }
        return arrangementAtomMatchCondition;
    }

    public String toString() {
        if (this.myType.equals(this.myValue)) {
            return String.format("%s%s", this.myInverted ? "not " : "", this.myType.getRepresentationValue());
        }
        return String.format("%s: %s%s", this.myType.getRepresentationValue(), this.myInverted ? "not " : "", this.myValue.toString().toLowerCase());
    }
}

