/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.match.DefaultArrangementEntryMatcherSerializer;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.psi.codeStyle.arrangement.std.StdRulePriorityAwareSettings;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultArrangementSettingsSerializer
implements ArrangementSettingsSerializer {
    private static final Logger LOG = Logger.getInstance((String)("#" + DefaultArrangementSettingsSerializer.class.getName()));
    @NotNull
    @NonNls
    private static final String GROUPS_ELEMENT_NAME = "groups";
    @NotNull
    @NonNls
    private static final String GROUP_ELEMENT_NAME = "group";
    @NotNull
    @NonNls
    private static final String RULES_ELEMENT_NAME = "rules";
    @NotNull
    @NonNls
    private static final String RULE_ELEMENT_NAME = "rule";
    @NotNull
    @NonNls
    private static final String TYPE_ELEMENT_NAME = "type";
    @NotNull
    @NonNls
    private static final String MATCHER_ELEMENT_NAME = "match";
    @NotNull
    @NonNls
    private static final String ORDER_TYPE_ELEMENT_NAME = "order";
    @NotNull
    private final DefaultArrangementEntryMatcherSerializer myMatcherSerializer;
    @NotNull
    private final Mixin myMixin;
    @NotNull
    private final ArrangementSettings myDefaultSettings;

    public DefaultArrangementSettingsSerializer(@NotNull StdArrangementSettings defaultSettings) {
        if (defaultSettings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "<init>"));
        }
        this(Mixin.NULL, defaultSettings);
    }

    public DefaultArrangementSettingsSerializer(@NotNull Mixin mixin, @NotNull StdArrangementSettings defaultSettings) {
        if (mixin == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "<init>"));
        }
        if (defaultSettings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "<init>"));
        }
        this.myMixin = mixin;
        this.myMatcherSerializer = new DefaultArrangementEntryMatcherSerializer(mixin);
        this.myDefaultSettings = defaultSettings;
    }

    @Override
    public void serialize(@NotNull ArrangementSettings s, @NotNull Element holder) {
        List<StdArrangementMatchRule> rules;
        boolean isDefaultRules;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "serialize"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "serialize"));
        }
        if (!(s instanceof StdArrangementSettings)) {
            return;
        }
        StdArrangementSettings settings = (StdArrangementSettings)s;
        List<ArrangementGroupingRule> groupings = settings.getGroupings();
        boolean isDefaultGroupings = ((Object)groupings).equals(this.myDefaultSettings.getGroupings());
        if (!isDefaultGroupings) {
            Element groupingsElement = new Element(GROUPS_ELEMENT_NAME);
            holder.addContent(groupingsElement);
            for (ArrangementGroupingRule group : groupings) {
                Element groupElement = new Element(GROUP_ELEMENT_NAME);
                groupingsElement.addContent(groupElement);
                groupElement.addContent(new Element(TYPE_ELEMENT_NAME).setText(group.getGroupingType().getId()));
                groupElement.addContent(new Element(ORDER_TYPE_ELEMENT_NAME).setText(group.getOrderType().getId()));
            }
        }
        if (!(isDefaultRules = ((Object)(rules = settings.getRules())).equals(this.myDefaultSettings.getRules()))) {
            Element rulesElement = new Element(RULES_ELEMENT_NAME);
            holder.addContent(rulesElement);
            for (StdArrangementMatchRule rule : rules) {
                rulesElement.addContent(this.serialize(rule));
            }
        }
    }

    @Override
    @Nullable
    public ArrangementSettings deserialize(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "deserialize"));
        }
        List<ArrangementGroupingRule> groupingRules = this.deserializeGropings(element, this.myDefaultSettings);
        List<StdArrangementMatchRule> rules = this.deserializeRules(element, this.myDefaultSettings);
        return new StdRulePriorityAwareSettings(groupingRules, rules);
    }

    @NotNull
    private List<ArrangementGroupingRule> deserializeGropings(@NotNull Element element, @Nullable ArrangementSettings defaultSettings) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "deserializeGropings"));
        }
        Element groups = element.getChild(GROUPS_ELEMENT_NAME);
        if (groups == null) {
            List list = defaultSettings == null ? ContainerUtil.newSmartList((Object[])new ArrangementGroupingRule[0]) : defaultSettings.getGroupings();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "deserializeGropings"));
            }
            return list;
        }
        ArrayList<ArrangementGroupingRule> groupings = new ArrayList<ArrangementGroupingRule>();
        for (Element group : groups.getChildren(GROUP_ELEMENT_NAME)) {
            Element groupElement = group;
            String groupingTypeId = groupElement.getChildText(TYPE_ELEMENT_NAME);
            ArrangementSettingsToken groupingType = StdArrangementTokens.byId(groupingTypeId);
            if (groupingType == null) {
                groupingType = this.myMixin.deserializeToken(groupingTypeId);
            }
            if (groupingType == null) {
                LOG.warn(String.format("Can't deserialize grouping type token by id '%s'", groupingTypeId));
                continue;
            }
            String orderTypeId = groupElement.getChildText(ORDER_TYPE_ELEMENT_NAME);
            ArrangementSettingsToken orderType = StdArrangementTokens.byId(orderTypeId);
            if (orderType == null) {
                orderType = this.myMixin.deserializeToken(orderTypeId);
            }
            if (orderType == null) {
                LOG.warn(String.format("Can't deserialize grouping order type token by id '%s'", orderTypeId));
                continue;
            }
            groupings.add(new ArrangementGroupingRule(groupingType, orderType));
        }
        ArrayList<ArrangementGroupingRule> arrayList = groupings;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "deserializeGropings"));
        }
        return arrayList;
    }

    @NotNull
    private List<StdArrangementMatchRule> deserializeRules(@NotNull Element element, @Nullable ArrangementSettings defaultSettings) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "deserializeRules"));
        }
        Element rulesElement = element.getChild(RULES_ELEMENT_NAME);
        if (rulesElement == null) {
            List list = defaultSettings instanceof StdArrangementSettings ? ((StdArrangementSettings)defaultSettings).getRules() : ContainerUtil.newSmartList((Object[])new StdArrangementMatchRule[0]);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "deserializeRules"));
            }
            return list;
        }
        ArrayList<StdArrangementMatchRule> rules = new ArrayList<StdArrangementMatchRule>();
        for (Element o : rulesElement.getChildren(RULE_ELEMENT_NAME)) {
            Element c;
            Element ruleElement = o;
            Element matcherElement = ruleElement.getChild(MATCHER_ELEMENT_NAME);
            if (matcherElement == null) continue;
            StdArrangementEntryMatcher matcher = null;
            Iterator i$ = matcherElement.getChildren().iterator();
            while (i$.hasNext() && (matcher = this.myMatcherSerializer.deserialize(c = (Element)i$.next())) == null) {
            }
            if (matcher == null) {
                List list = ContainerUtil.newSmartList((Object[])new Object[0]);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "deserializeRules"));
                }
                return list;
            }
            Element orderTypeElement = ruleElement.getChild(ORDER_TYPE_ELEMENT_NAME);
            ArrangementSettingsToken orderType = null;
            if (orderTypeElement != null) {
                String orderTypeId = orderTypeElement.getText();
                orderType = StdArrangementTokens.byId(orderTypeId);
                if (orderType == null) {
                    orderType = this.myMixin.deserializeToken(orderTypeId);
                }
                if (orderType == null) {
                    LOG.warn(String.format("Can't deserialize matching rule order type for id '%s'. Falling back to default (%s)", orderTypeId, ArrangementMatchRule.DEFAULT_ORDER_TYPE.getId()));
                }
            }
            if (orderType == null) {
                orderType = ArrangementMatchRule.DEFAULT_ORDER_TYPE;
            }
            rules.add(new StdArrangementMatchRule(matcher, orderType));
        }
        ArrayList<StdArrangementMatchRule> arrayList = rules;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "deserializeRules"));
        }
        return arrayList;
    }

    @Nullable
    public Element serialize(@NotNull ArrangementMatchRule rule) {
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "serialize"));
        }
        Element matcherElement = this.myMatcherSerializer.serialize(rule.getMatcher());
        if (matcherElement == null) {
            return null;
        }
        Element result = new Element(RULE_ELEMENT_NAME);
        result.addContent(new Element(MATCHER_ELEMENT_NAME).addContent(matcherElement));
        if (rule.getOrderType() != ArrangementMatchRule.DEFAULT_ORDER_TYPE) {
            result.addContent(new Element(ORDER_TYPE_ELEMENT_NAME).setText(rule.getOrderType().getId()));
        }
        return result;
    }

    public static interface Mixin {
        public static final Mixin NULL = new Mixin(){

            @Override
            @Nullable
            public ArrangementSettingsToken deserializeToken(@NotNull String id) {
                if (id == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer$Mixin$1", "deserializeToken"));
                }
                return null;
            }
        };

        @Nullable
        public ArrangementSettingsToken deserializeToken(@NotNull String var1);
    }
}

