/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.RulePriorityAwareSettings;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.match.ByModifierArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByNameArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByNamespaceArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByTypeArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.CompositeArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementUiComponent;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokenType;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokenUiRole;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementUtil {
    private static final Logger LOG = Logger.getInstance(ArrangementUtil.class);

    private ArrangementUtil() {
    }

    @Nullable
    public static ArrangementSettings readExternal(@NotNull Element element, @NotNull Language language) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil", "readExternal"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil", "readExternal"));
        }
        ArrangementSettingsSerializer serializer = ArrangementUtil.getSerializer(language);
        if (serializer == null) {
            LOG.error("Can't find serializer for language: " + language.getDisplayName() + "(" + language.getID() + ")");
            return null;
        }
        return serializer.deserialize(element);
    }

    public static void writeExternal(@NotNull Element element, @NotNull ArrangementSettings settings, @NotNull Language language) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil", "writeExternal"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil", "writeExternal"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil", "writeExternal"));
        }
        ArrangementSettingsSerializer serializer = ArrangementUtil.getSerializer(language);
        if (serializer == null) {
            LOG.error("Can't find serializer for language: " + language.getDisplayName() + "(" + language.getID() + ")");
            return;
        }
        serializer.serialize(settings, element);
    }

    @Nullable
    private static ArrangementSettingsSerializer getSerializer(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil", "getSerializer"));
        }
        Rearranger<?> rearranger = Rearranger.EXTENSION.forLanguage(language);
        return rearranger == null ? null : rearranger.getSerializer();
    }

    @NotNull
    public static ArrangementMatchCondition combine(ArrangementMatchCondition ... nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil", "combine"));
        }
        final ArrangementCompositeMatchCondition result = new ArrangementCompositeMatchCondition();
        ArrangementMatchConditionVisitor visitor = new ArrangementMatchConditionVisitor(){

            @Override
            public void visit(@NotNull ArrangementAtomMatchCondition node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil$1", "visit"));
                }
                result.addOperand(node);
            }

            @Override
            public void visit(@NotNull ArrangementCompositeMatchCondition node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil$1", "visit"));
                }
                for (ArrangementMatchCondition operand : node.getOperands()) {
                    operand.invite(this);
                }
            }
        };
        for (ArrangementMatchCondition node : nodes) {
            node.invite(visitor);
        }
        ArrangementMatchCondition arrangementMatchCondition = result.getOperands().size() == 1 ? result.getOperands().iterator().next() : result;
        if (arrangementMatchCondition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil", "combine"));
        }
        return arrangementMatchCondition;
    }

    @NotNull
    public static TextRange expandToLineIfPossible(@NotNull TextRange initialRange, @NotNull Document document) {
        if (initialRange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil", "expandToLineIfPossible"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil", "expandToLineIfPossible"));
        }
        CharSequence text = document.getCharsSequence();
        String ws = " \t";
        int startLine = document.getLineNumber(initialRange.getStartOffset());
        int lineStartOffset = document.getLineStartOffset(startLine);
        int i = CharArrayUtil.shiftBackward((CharSequence)text, (int)(lineStartOffset + 1), (int)(initialRange.getStartOffset() - 1), (String)ws);
        if (i != lineStartOffset) {
            TextRange textRange = initialRange;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil", "expandToLineIfPossible"));
            }
            return textRange;
        }
        int endLine = document.getLineNumber(initialRange.getEndOffset());
        int lineEndOffset = document.getLineEndOffset(endLine);
        i = CharArrayUtil.shiftForward((CharSequence)text, (int)initialRange.getEndOffset(), (int)lineEndOffset, (String)ws);
        TextRange textRange = i == lineEndOffset ? TextRange.create((int)lineStartOffset, (int)lineEndOffset) : initialRange;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil", "expandToLineIfPossible"));
        }
        return textRange;
    }

    @Nullable
    public static ArrangementSettingsToken parseType(@NotNull ArrangementMatchCondition condition) throws IllegalArgumentException {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil", "parseType"));
        }
        final Ref result = new Ref();
        condition.invite(new ArrangementMatchConditionVisitor(){

            @Override
            public void visit(@NotNull ArrangementAtomMatchCondition condition) {
                if (condition == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil$2", "visit"));
                }
                if (StdArrangementTokenType.ENTRY_TYPE.is(condition.getType())) {
                    result.set((Object)condition.getType());
                }
            }

            @Override
            public void visit(@NotNull ArrangementCompositeMatchCondition condition) {
                if (condition == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil$2", "visit"));
                }
                for (ArrangementMatchCondition c : condition.getOperands()) {
                    c.invite(this);
                    if (result.get() == null) continue;
                    return;
                }
            }
        });
        return (ArrangementSettingsToken)result.get();
    }

    public static <T> Set<T> flatten(@NotNull Iterable<? extends Iterable<T>> data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil", "flatten"));
        }
        HashSet result = ContainerUtilRt.newHashSet();
        for (Iterable<T> i : data) {
            for (T t : i) {
                result.add(t);
            }
        }
        return result;
    }

    @NotNull
    public static Map<ArrangementSettingsToken, Object> extractTokens(@NotNull ArrangementMatchCondition condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil", "extractTokens"));
        }
        final HashMap result = ContainerUtilRt.newHashMap();
        condition.invite(new ArrangementMatchConditionVisitor(){

            @Override
            public void visit(@NotNull ArrangementAtomMatchCondition condition) {
                if (condition == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil$3", "visit"));
                }
                ArrangementSettingsToken type = condition.getType();
                Object value = condition.getValue();
                result.put(condition.getType(), type.equals(value) ? null : value);
            }

            @Override
            public void visit(@NotNull ArrangementCompositeMatchCondition condition) {
                if (condition == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil$3", "visit"));
                }
                for (ArrangementMatchCondition operand : condition.getOperands()) {
                    operand.invite(this);
                }
            }
        });
        HashMap hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil", "extractTokens"));
        }
        return hashMap;
    }

    @Nullable
    public static ArrangementEntryMatcher buildMatcher(@NotNull ArrangementMatchCondition condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil", "buildMatcher"));
        }
        final Ref result = new Ref();
        final Stack composites = new Stack();
        ArrangementMatchConditionVisitor visitor = new ArrangementMatchConditionVisitor(){

            @Override
            public void visit(@NotNull ArrangementAtomMatchCondition condition) {
                if (condition == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil$4", "visit"));
                }
                ArrangementEntryMatcher matcher = ArrangementUtil.buildMatcher(condition);
                if (matcher == null) {
                    return;
                }
                if (composites.isEmpty()) {
                    result.set((Object)matcher);
                } else {
                    ((CompositeArrangementEntryMatcher)composites.peek()).addMatcher(matcher);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visit(@NotNull ArrangementCompositeMatchCondition condition) {
                if (condition == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil$4", "visit"));
                }
                composites.push(new CompositeArrangementEntryMatcher(new ArrangementEntryMatcher[0]));
                try {
                    for (ArrangementMatchCondition operand : condition.getOperands()) {
                        operand.invite(this);
                    }
                }
                finally {
                    CompositeArrangementEntryMatcher matcher = (CompositeArrangementEntryMatcher)composites.pop();
                    if (composites.isEmpty()) {
                        result.set((Object)matcher);
                    }
                }
            }
        };
        condition.invite(visitor);
        return (ArrangementEntryMatcher)result.get();
    }

    @Nullable
    public static ArrangementEntryMatcher buildMatcher(@NotNull ArrangementAtomMatchCondition condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil", "buildMatcher"));
        }
        if (StdArrangementTokenType.ENTRY_TYPE.is(condition.getType())) {
            return new ByTypeArrangementEntryMatcher(condition.getType());
        }
        if (StdArrangementTokenType.MODIFIER.is(condition.getType())) {
            return new ByModifierArrangementEntryMatcher(condition.getType());
        }
        if (StdArrangementTokens.Regexp.NAME.equals(condition.getType())) {
            return new ByNameArrangementEntryMatcher(condition.getValue().toString());
        }
        if (StdArrangementTokens.Regexp.XML_NAMESPACE.equals(condition.getType())) {
            return new ByNamespaceArrangementEntryMatcher(condition.getValue().toString());
        }
        return null;
    }

    @NotNull
    public static ArrangementUiComponent buildUiComponent(@NotNull StdArrangementTokenUiRole role, @NotNull List<ArrangementSettingsToken> tokens, @NotNull ArrangementColorsProvider colorsProvider, @NotNull ArrangementStandardSettingsManager settingsManager) throws IllegalArgumentException {
        if (role == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil", "buildUiComponent"));
        }
        if (tokens == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil", "buildUiComponent"));
        }
        if (colorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil", "buildUiComponent"));
        }
        if (settingsManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil", "buildUiComponent"));
        }
        for (ArrangementUiComponent.Factory factory : (ArrangementUiComponent.Factory[])Extensions.getExtensions(ArrangementUiComponent.Factory.EP_NAME)) {
            ArrangementUiComponent result = factory.build(role, tokens, colorsProvider, settingsManager);
            if (result == null) continue;
            ArrangementUiComponent arrangementUiComponent = result;
            if (arrangementUiComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil", "buildUiComponent"));
            }
            return arrangementUiComponent;
        }
        throw new IllegalArgumentException("Unsupported UI token role " + (Object)((Object)role));
    }

    @NotNull
    public static List<CompositeArrangementSettingsToken> flatten(@NotNull CompositeArrangementSettingsToken base) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil", "flatten"));
        }
        ArrayList result = ContainerUtilRt.newArrayList();
        LinkedList toProcess = ContainerUtilRt.newLinkedList((Object[])new CompositeArrangementSettingsToken[]{base});
        while (!toProcess.isEmpty()) {
            CompositeArrangementSettingsToken token = (CompositeArrangementSettingsToken)toProcess.remove();
            result.add(token);
            toProcess.addAll(token.getChildren());
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil", "flatten"));
        }
        return arrayList;
    }

    @NotNull
    public static List<? extends ArrangementMatchRule> getRulesSortedByPriority(@NotNull ArrangementSettings arrangementSettings) {
        if (arrangementSettings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil", "getRulesSortedByPriority"));
        }
        List<? extends ArrangementMatchRule> list = arrangementSettings instanceof RulePriorityAwareSettings ? ((RulePriorityAwareSettings)arrangementSettings).getRulesSortedByPriority() : arrangementSettings.getRules();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil", "getRulesSortedByPriority"));
        }
        return list;
    }
}

