/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.java;

import com.intellij.core.JavaCoreBundle;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum LanguageLevel {
    JDK_1_3(JavaCoreBundle.message("jdk.1.3.language.level.description", new Object[0])),
    JDK_1_4(JavaCoreBundle.message("jdk.1.4.language.level.description", new Object[0])),
    JDK_1_5(JavaCoreBundle.message("jdk.1.5.language.level.description", new Object[0])),
    JDK_1_6(JavaCoreBundle.message("jdk.1.6.language.level.description", new Object[0])),
    JDK_1_7(JavaCoreBundle.message("jdk.1.7.language.level.description", new Object[0])),
    JDK_1_8(JavaCoreBundle.message("jdk.1.8.language.level.description", new Object[0])),
    JDK_1_9(JavaCoreBundle.message("jdk.1.9.language.level.description", new Object[0]));

    public static final LanguageLevel HIGHEST;
    public static final Key<LanguageLevel> KEY;
    private final String myPresentableText;

    private LanguageLevel(String presentableText) {
        if (presentableText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/pom/java/LanguageLevel", "<init>"));
        }
        this.myPresentableText = presentableText;
    }

    @NotNull
    @Nls
    public String getPresentableText() {
        String string = this.myPresentableText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/pom/java/LanguageLevel", "getPresentableText"));
        }
        return string;
    }

    public boolean isAtLeast(@NotNull LanguageLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/pom/java/LanguageLevel", "isAtLeast"));
        }
        return this.compareTo(level) >= 0;
    }

    @Nullable
    public static LanguageLevel parse(@Nullable String value) {
        if ("1.3".equals(value)) {
            return JDK_1_3;
        }
        if ("1.4".equals(value)) {
            return JDK_1_4;
        }
        if ("1.5".equals(value)) {
            return JDK_1_5;
        }
        if ("1.6".equals(value)) {
            return JDK_1_6;
        }
        if ("1.7".equals(value)) {
            return JDK_1_7;
        }
        if ("1.8".equals(value)) {
            return JDK_1_8;
        }
        if ("1.9".equals(value)) {
            return JDK_1_9;
        }
        return null;
    }

    static {
        HIGHEST = JDK_1_8;
        KEY = Key.create((String)"LANGUAGE_LEVEL");
    }
}

