/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiMemberPattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiClassPattern
extends PsiMemberPattern<PsiClass, PsiClassPattern> {
    protected PsiClassPattern() {
        super(PsiClass.class);
    }

    public PsiClassPattern inheritorOf(final boolean strict, final PsiClassPattern pattern) {
        return (PsiClassPattern)this.with(new PatternCondition<PsiClass>("inheritorOf"){

            @Override
            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                if (psiClass == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/PsiClassPattern$1", "accepts"));
                }
                return PsiClassPattern.isInheritor(psiClass, pattern, context, !strict);
            }
        });
    }

    private static boolean isInheritor(PsiClass psiClass, ElementPattern pattern, ProcessingContext matchingContext, boolean checkThisClass) {
        if (psiClass == null) {
            return false;
        }
        if (checkThisClass && pattern.getCondition().accepts(psiClass, matchingContext)) {
            return true;
        }
        if (PsiClassPattern.isInheritor(psiClass.getSuperClass(), pattern, matchingContext, true)) {
            return true;
        }
        for (PsiClass aClass : psiClass.getInterfaces()) {
            if (!PsiClassPattern.isInheritor(aClass, pattern, matchingContext, true)) continue;
            return true;
        }
        return false;
    }

    public PsiClassPattern inheritorOf(final boolean strict, final String className) {
        return (PsiClassPattern)this.with(new PatternCondition<PsiClass>("inheritorOf"){

            @Override
            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                if (psiClass == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/PsiClassPattern$2", "accepts"));
                }
                return InheritanceUtil.isInheritor(psiClass, strict, className);
            }
        });
    }

    public PsiClassPattern isInterface() {
        return (PsiClassPattern)this.with(new PatternCondition<PsiClass>("isInterface"){

            @Override
            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                if (psiClass == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/PsiClassPattern$3", "accepts"));
                }
                return psiClass.isInterface();
            }
        });
    }

    public PsiClassPattern isAnnotationType() {
        return (PsiClassPattern)this.with(new PatternCondition<PsiClass>("isAnnotationType"){

            @Override
            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                if (psiClass == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/PsiClassPattern$4", "accepts"));
                }
                return psiClass.isAnnotationType();
            }
        });
    }

    public PsiClassPattern withMethod(final boolean checkDeep, final ElementPattern<? extends PsiMethod> memberPattern) {
        return (PsiClassPattern)this.with(new PatternCondition<PsiClass>("withMethod"){

            @Override
            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                if (psiClass == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/PsiClassPattern$5", "accepts"));
                }
                for (PsiMethod method : checkDeep ? psiClass.getAllMethods() : psiClass.getMethods()) {
                    if (!memberPattern.accepts(method, context)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public PsiClassPattern withField(final boolean checkDeep, final ElementPattern<? extends PsiField> memberPattern) {
        return (PsiClassPattern)this.with(new PatternCondition<PsiClass>("withField"){

            @Override
            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                if (psiClass == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/PsiClassPattern$6", "accepts"));
                }
                for (PsiField field : checkDeep ? psiClass.getAllFields() : psiClass.getFields()) {
                    if (!memberPattern.accepts(field, context)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public PsiClassPattern nonAnnotationType() {
        return (PsiClassPattern)this.with(new PatternCondition<PsiClass>("nonAnnotationType"){

            @Override
            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                if (psiClass == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/PsiClassPattern$7", "accepts"));
                }
                return !psiClass.isAnnotationType();
            }
        });
    }

    public PsiClassPattern withQualifiedName(final @NonNls @NotNull String qname) {
        if (qname == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/PsiClassPattern", "withQualifiedName"));
        }
        return (PsiClassPattern)this.with(new PatternCondition<PsiClass>("withQualifiedName"){

            @Override
            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                if (psiClass == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/PsiClassPattern$8", "accepts"));
                }
                return qname.equals(psiClass.getQualifiedName());
            }
        });
    }

    public PsiClassPattern withQualifiedName(final @NonNls @NotNull ElementPattern<String> qname) {
        if (qname == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/PsiClassPattern", "withQualifiedName"));
        }
        return (PsiClassPattern)this.with(new PatternCondition<PsiClass>("withQualifiedName"){

            @Override
            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                if (psiClass == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/PsiClassPattern$9", "accepts"));
                }
                return qname.accepts(psiClass.getQualifiedName(), context);
            }
        });
    }
}

