/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.DomChildrenDescription;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DomElementPattern<T extends DomElement, Self extends DomElementPattern<T, Self>>
extends TreeElementPattern<DomElement, T, Self> {
    protected DomElementPattern(Class<T> aClass) {
        super(aClass);
    }

    protected DomElementPattern(@NotNull InitialPatternCondition<T> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/DomElementPattern", "<init>"));
        }
        super(condition);
    }

    @Override
    protected DomElement getParent(@NotNull DomElement t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/DomElementPattern", "getParent"));
        }
        return t.getParent();
    }

    protected DomElement[] getChildren(@NotNull DomElement domElement) {
        if (domElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/DomElementPattern", "getChildren"));
        }
        final ArrayList children = new ArrayList();
        domElement.acceptChildren(new DomElementVisitor(){

            @Override
            public void visitDomElement(DomElement element) {
                children.add(element);
            }
        });
        return children.toArray(new DomElement[children.size()]);
    }

    public Self withChild(final @NonNls @NotNull String localName, final ElementPattern pattern) {
        if (localName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/DomElementPattern", "withChild"));
        }
        return (Self)((DomElementPattern)this.with(new PatternCondition<T>("withChild"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/DomElementPattern$2", "accepts"));
                }
                for (AbstractDomChildrenDescription abstractDomChildrenDescription : t.getGenericInfo().getChildrenDescriptions()) {
                    if (abstractDomChildrenDescription instanceof DomChildrenDescription && !localName.equals(((DomChildrenDescription)abstractDomChildrenDescription).getXmlElementName())) continue;
                    for (DomElement domElement : abstractDomChildrenDescription.getValues((DomElement)t)) {
                        if (!localName.equals(domElement.getXmlElementName()) || !pattern.getCondition().accepts(domElement, context)) continue;
                        return true;
                    }
                }
                return false;
            }
        }));
    }

    public static class Capture<T extends DomElement>
    extends DomElementPattern<T, Capture<T>> {
        protected Capture(Class<T> aClass) {
            super(aClass);
        }
    }
}

